/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.services.workdocs.model.SharedLabelsCopier;
import software.amazon.awssdk.services.workdocs.transform.FolderMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FolderMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, FolderMetadata> {
    private final String id;
    private final String name;
    private final String creatorId;
    private final String parentFolderId;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final String resourceState;
    private final String signature;
    private final List<String> labels;
    private final Long size;
    private final Long latestVersionSize;

    private FolderMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.resourceState = builder.resourceState;
        this.signature = builder.signature;
        this.labels = builder.labels;
        this.size = builder.size;
        this.latestVersionSize = builder.latestVersionSize;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public ResourceStateType resourceState() {
        return ResourceStateType.fromValue(this.resourceState);
    }

    public String resourceStateAsString() {
        return this.resourceState;
    }

    public String signature() {
        return this.signature;
    }

    public List<String> labels() {
        return this.labels;
    }

    public Long size() {
        return this.size;
    }

    public Long latestVersionSize() {
        return this.latestVersionSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderMetadata)) {
            return false;
        }
        FolderMetadata other = (FolderMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.parentFolderId(), other.parentFolderId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.resourceStateAsString(), other.resourceStateAsString()) && Objects.equals(this.signature(), other.signature()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.latestVersionSize(), other.latestVersionSize());
    }

    public String toString() {
        return ToString.builder((String)"FolderMetadata").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("CreatorId", (Object)this.creatorId()).add("ParentFolderId", (Object)this.parentFolderId()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ModifiedTimestamp", (Object)this.modifiedTimestamp()).add("ResourceState", (Object)this.resourceStateAsString()).add("Signature", (Object)this.signature()).add("Labels", this.labels()).add("Size", (Object)this.size()).add("LatestVersionSize", (Object)this.latestVersionSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "CreatorId": {
                return Optional.of(clazz.cast(this.creatorId()));
            }
            case "ParentFolderId": {
                return Optional.of(clazz.cast(this.parentFolderId()));
            }
            case "CreatedTimestamp": {
                return Optional.of(clazz.cast(this.createdTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.of(clazz.cast(this.modifiedTimestamp()));
            }
            case "ResourceState": {
                return Optional.of(clazz.cast(this.resourceStateAsString()));
            }
            case "Signature": {
                return Optional.of(clazz.cast(this.signature()));
            }
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
            case "LatestVersionSize": {
                return Optional.of(clazz.cast(this.latestVersionSize()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FolderMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String creatorId;
        private String parentFolderId;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private String resourceState;
        private String signature;
        private List<String> labels;
        private Long size;
        private Long latestVersionSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderMetadata model) {
            this.id(model.id);
            this.name(model.name);
            this.creatorId(model.creatorId);
            this.parentFolderId(model.parentFolderId);
            this.createdTimestamp(model.createdTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.resourceState(model.resourceState);
            this.signature(model.signature);
            this.labels(model.labels);
            this.size(model.size);
            this.latestVersionSize(model.latestVersionSize);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final Long getLatestVersionSize() {
            return this.latestVersionSize;
        }

        @Override
        public final Builder latestVersionSize(Long latestVersionSize) {
            this.latestVersionSize = latestVersionSize;
            return this;
        }

        public final void setLatestVersionSize(Long latestVersionSize) {
            this.latestVersionSize = latestVersionSize;
        }

        public FolderMetadata build() {
            return new FolderMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FolderMetadata> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder creatorId(String var1);

        public Builder parentFolderId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);

        public Builder signature(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder size(Long var1);

        public Builder latestVersionSize(Long var1);
    }
}

