/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.model.ResourcePath;
import software.amazon.awssdk.services.workdocs.transform.ResourcePathComponentUnmarshaller;

public class ResourcePathUnmarshaller
implements Unmarshaller<ResourcePath, JsonUnmarshallerContext> {
    private static ResourcePathUnmarshaller INSTANCE;

    public ResourcePath unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourcePath.Builder resourcePathBuilder = ResourcePath.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Components", targetDepth)) {
                    context.nextToken();
                    resourcePathBuilder.components(new ListUnmarshaller((Unmarshaller)ResourcePathComponentUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourcePath)resourcePathBuilder.build();
    }

    public static ResourcePathUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourcePathUnmarshaller();
        }
        return INSTANCE;
    }
}

