/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.StorageType;
import software.amazon.awssdk.services.workdocs.transform.StorageRuleTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageRuleType
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageRuleType> {
    private final Long storageAllocatedInBytes;
    private final String storageType;

    private StorageRuleType(BuilderImpl builder) {
        this.storageAllocatedInBytes = builder.storageAllocatedInBytes;
        this.storageType = builder.storageType;
    }

    public Long storageAllocatedInBytes() {
        return this.storageAllocatedInBytes;
    }

    public String storageType() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.storageAllocatedInBytes() == null ? 0 : this.storageAllocatedInBytes().hashCode());
        hashCode = 31 * hashCode + (this.storageType() == null ? 0 : this.storageType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageRuleType)) {
            return false;
        }
        StorageRuleType other = (StorageRuleType)obj;
        if (other.storageAllocatedInBytes() == null ^ this.storageAllocatedInBytes() == null) {
            return false;
        }
        if (other.storageAllocatedInBytes() != null && !other.storageAllocatedInBytes().equals(this.storageAllocatedInBytes())) {
            return false;
        }
        if (other.storageType() == null ^ this.storageType() == null) {
            return false;
        }
        return other.storageType() == null || other.storageType().equals(this.storageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.storageAllocatedInBytes() != null) {
            sb.append("StorageAllocatedInBytes: ").append(this.storageAllocatedInBytes()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageRuleTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long storageAllocatedInBytes;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageRuleType model) {
            this.setStorageAllocatedInBytes(model.storageAllocatedInBytes);
            this.setStorageType(model.storageType);
        }

        public final Long getStorageAllocatedInBytes() {
            return this.storageAllocatedInBytes;
        }

        @Override
        public final Builder storageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
            return this;
        }

        public final void setStorageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType.toString());
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final void setStorageType(StorageType storageType) {
            this.storageType(storageType.toString());
        }

        public StorageRuleType build() {
            return new StorageRuleType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageRuleType> {
        public Builder storageAllocatedInBytes(Long var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);
    }
}

