/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFolderContentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFolderContentsResponse> {
    private final List<FolderMetadata> folders;
    private final List<DocumentMetadata> documents;
    private final String marker;

    private DescribeFolderContentsResponse(BuilderImpl builder) {
        this.folders = builder.folders;
        this.documents = builder.documents;
        this.marker = builder.marker;
    }

    public List<FolderMetadata> folders() {
        return this.folders;
    }

    public List<DocumentMetadata> documents() {
        return this.documents;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.folders() == null ? 0 : this.folders().hashCode());
        hashCode = 31 * hashCode + (this.documents() == null ? 0 : this.documents().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsResponse)) {
            return false;
        }
        DescribeFolderContentsResponse other = (DescribeFolderContentsResponse)((Object)obj);
        if (other.folders() == null ^ this.folders() == null) {
            return false;
        }
        if (other.folders() != null && !other.folders().equals(this.folders())) {
            return false;
        }
        if (other.documents() == null ^ this.documents() == null) {
            return false;
        }
        if (other.documents() != null && !other.documents().equals(this.documents())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.folders() != null) {
            sb.append("Folders: ").append(this.folders()).append(",");
        }
        if (this.documents() != null) {
            sb.append("Documents: ").append(this.documents()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FolderMetadata> folders;
        private List<DocumentMetadata> documents;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsResponse model) {
            this.setFolders(model.folders);
            this.setDocuments(model.documents);
            this.setMarker(model.marker);
        }

        public final Collection<FolderMetadata> getFolders() {
            return this.folders;
        }

        @Override
        public final Builder folders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(FolderMetadata ... folders) {
            if (this.folders == null) {
                this.folders = new ArrayList<FolderMetadata>(folders.length);
            }
            for (FolderMetadata e : folders) {
                this.folders.add(e);
            }
            return this;
        }

        public final void setFolders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
        }

        @SafeVarargs
        public final void setFolders(FolderMetadata ... folders) {
            if (this.folders == null) {
                this.folders = new ArrayList<FolderMetadata>(folders.length);
            }
            for (FolderMetadata e : folders) {
                this.folders.add(e);
            }
        }

        public final Collection<DocumentMetadata> getDocuments() {
            return this.documents;
        }

        @Override
        public final Builder documents(Collection<DocumentMetadata> documents) {
            this.documents = DocumentMetadataListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DocumentMetadata ... documents) {
            if (this.documents == null) {
                this.documents = new ArrayList<DocumentMetadata>(documents.length);
            }
            for (DocumentMetadata e : documents) {
                this.documents.add(e);
            }
            return this;
        }

        public final void setDocuments(Collection<DocumentMetadata> documents) {
            this.documents = DocumentMetadataListCopier.copy(documents);
        }

        @SafeVarargs
        public final void setDocuments(DocumentMetadata ... documents) {
            if (this.documents == null) {
                this.documents = new ArrayList<DocumentMetadata>(documents.length);
            }
            for (DocumentMetadata e : documents) {
                this.documents.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeFolderContentsResponse build() {
            return new DescribeFolderContentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFolderContentsResponse> {
        public Builder folders(Collection<FolderMetadata> var1);

        public Builder folders(FolderMetadata ... var1);

        public Builder documents(Collection<DocumentMetadata> var1);

        public Builder documents(DocumentMetadata ... var1);

        public Builder marker(String var1);
    }
}

