/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.SharePrincipal;
import software.amazon.awssdk.services.workdocs.model.SharePrincipalListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddResourcePermissionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddResourcePermissionsRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final List<SharePrincipal> principals;

    private AddResourcePermissionsRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.principals = builder.principals;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<SharePrincipal> principals() {
        return this.principals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.principals() == null ? 0 : this.principals().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddResourcePermissionsRequest)) {
            return false;
        }
        AddResourcePermissionsRequest other = (AddResourcePermissionsRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.principals() == null ^ this.principals() == null) {
            return false;
        }
        return other.principals() == null || other.principals().equals(this.principals());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.principals() != null) {
            sb.append("Principals: ").append(this.principals()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private List<SharePrincipal> principals;

        private BuilderImpl() {
        }

        private BuilderImpl(AddResourcePermissionsRequest model) {
            this.setAuthenticationToken(model.authenticationToken);
            this.setResourceId(model.resourceId);
            this.setPrincipals(model.principals);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<SharePrincipal> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<SharePrincipal> principals) {
            this.principals = SharePrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(SharePrincipal ... principals) {
            if (this.principals == null) {
                this.principals = new ArrayList<SharePrincipal>(principals.length);
            }
            for (SharePrincipal e : principals) {
                this.principals.add(e);
            }
            return this;
        }

        public final void setPrincipals(Collection<SharePrincipal> principals) {
            this.principals = SharePrincipalListCopier.copy(principals);
        }

        @SafeVarargs
        public final void setPrincipals(SharePrincipal ... principals) {
            if (this.principals == null) {
                this.principals = new ArrayList<SharePrincipal>(principals.length);
            }
            for (SharePrincipal e : principals) {
                this.principals.add(e);
            }
        }

        public AddResourcePermissionsRequest build() {
            return new AddResourcePermissionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddResourcePermissionsRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder principals(Collection<SharePrincipal> var1);

        public Builder principals(SharePrincipal ... var1);
    }
}

