/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.internal.UserAgentUtils;
import software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest;
import software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse;
import software.amazon.awssdk.services.wisdom.model.SessionSummary;

public class SearchSessionsPublisher
implements SdkPublisher<SearchSessionsResponse> {
    private final WisdomAsyncClient client;
    private final SearchSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSessionsPublisher(WisdomAsyncClient client, SearchSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSessionsPublisher(WisdomAsyncClient client, SearchSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SessionSummary> sessionSummaries() {
        Function<SearchSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionSummaries() != null) {
                return response.sessionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchSessionsResponseFetcher
    implements AsyncPageFetcher<SearchSessionsResponse> {
        private SearchSessionsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSessionsResponse> nextPage(SearchSessionsResponse previousPage) {
            if (previousPage == null) {
                return SearchSessionsPublisher.this.client.searchSessions(SearchSessionsPublisher.this.firstRequest);
            }
            return SearchSessionsPublisher.this.client.searchSessions((SearchSessionsRequest)((Object)SearchSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

