/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.internal.UserAgentUtils;
import software.amazon.awssdk.services.wisdom.model.ImportJobSummary;
import software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest;
import software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse;

public class ListImportJobsIterable
implements SdkIterable<ListImportJobsResponse> {
    private final WisdomClient client;
    private final ListImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportJobsIterable(WisdomClient client, ListImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportJobsResponseFetcher();
    }

    public Iterator<ListImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportJobSummary> importJobSummaries() {
        Function<ListImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobSummaries() != null) {
                return response.importJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportJobsResponseFetcher
    implements SyncPageFetcher<ListImportJobsResponse> {
        private ListImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportJobsResponse nextPage(ListImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListImportJobsIterable.this.client.listImportJobs(ListImportJobsIterable.this.firstRequest);
            }
            return ListImportJobsIterable.this.client.listImportJobs((ListImportJobsRequest)((Object)ListImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

