/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.model.ContentSummary;
import software.amazon.awssdk.services.wisdom.model.ListContentsRequest;
import software.amazon.awssdk.services.wisdom.model.ListContentsResponse;

public class ListContentsPublisher
implements SdkPublisher<ListContentsResponse> {
    private final WisdomAsyncClient client;
    private final ListContentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContentsPublisher(WisdomAsyncClient client, ListContentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContentsPublisher(WisdomAsyncClient client, ListContentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContentSummary> contentSummaries() {
        Function<ListContentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contentSummaries() != null) {
                return response.contentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContentsResponseFetcher
    implements AsyncPageFetcher<ListContentsResponse> {
        private ListContentsResponseFetcher() {
        }

        public boolean hasNextPage(ListContentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContentsResponse> nextPage(ListContentsResponse previousPage) {
            if (previousPage == null) {
                return ListContentsPublisher.this.client.listContents(ListContentsPublisher.this.firstRequest);
            }
            return ListContentsPublisher.this.client.listContents((ListContentsRequest)((Object)ListContentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

