/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuestUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuestUser> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingPeriod").getter(GuestUser.getter(GuestUser::billingPeriod)).setter(GuestUser.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingPeriod").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(GuestUser.getter(GuestUser::username)).setter(GuestUser.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> USERNAME_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usernameHash").getter(GuestUser.getter(GuestUser::usernameHash)).setter(GuestUser.setter(Builder::usernameHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernameHash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD, USERNAME_FIELD, USERNAME_HASH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuestUser.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String billingPeriod;
    private final String username;
    private final String usernameHash;

    private GuestUser(BuilderImpl builder) {
        this.billingPeriod = builder.billingPeriod;
        this.username = builder.username;
        this.usernameHash = builder.usernameHash;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final String username() {
        return this.username;
    }

    public final String usernameHash() {
        return this.usernameHash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernameHash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuestUser)) {
            return false;
        }
        GuestUser other = (GuestUser)obj;
        return Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.usernameHash(), other.usernameHash());
    }

    public final String toString() {
        return ToString.builder((String)"GuestUser").add("BillingPeriod", (Object)this.billingPeriod()).add("Username", (Object)this.username()).add("UsernameHash", (Object)this.usernameHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "usernameHash": {
                return Optional.ofNullable(clazz.cast(this.usernameHash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("billingPeriod", BILLING_PERIOD_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("usernameHash", USERNAME_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuestUser, T> g) {
        return obj -> g.apply((GuestUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String billingPeriod;
        private String username;
        private String usernameHash;

        private BuilderImpl() {
        }

        private BuilderImpl(GuestUser model) {
            this.billingPeriod(model.billingPeriod);
            this.username(model.username);
            this.usernameHash(model.usernameHash);
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getUsernameHash() {
            return this.usernameHash;
        }

        public final void setUsernameHash(String usernameHash) {
            this.usernameHash = usernameHash;
        }

        @Override
        public final Builder usernameHash(String usernameHash) {
            this.usernameHash = usernameHash;
            return this;
        }

        public GuestUser build() {
            return new GuestUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuestUser> {
        public Builder billingPeriod(String var1);

        public Builder username(String var1);

        public Builder usernameHash(String var1);
    }
}

