/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.StringListCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterOidcConfigTestResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, RegisterOidcConfigTestResponse> {
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenEndpoint").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::tokenEndpoint)).setter(RegisterOidcConfigTestResponse.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpoint").build()}).build();
    private static final SdkField<String> USERINFO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userinfoEndpoint").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::userinfoEndpoint)).setter(RegisterOidcConfigTestResponse.setter(Builder::userinfoEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userinfoEndpoint").build()}).build();
    private static final SdkField<List<String>> RESPONSE_TYPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("responseTypesSupported").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::responseTypesSupported)).setter(RegisterOidcConfigTestResponse.setter(Builder::responseTypesSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTypesSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SCOPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scopesSupported").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::scopesSupported)).setter(RegisterOidcConfigTestResponse.setter(Builder::scopesSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopesSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::issuer)).setter(RegisterOidcConfigTestResponse.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationEndpoint").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::authorizationEndpoint)).setter(RegisterOidcConfigTestResponse.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationEndpoint").build()}).build();
    private static final SdkField<String> END_SESSION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endSessionEndpoint").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::endSessionEndpoint)).setter(RegisterOidcConfigTestResponse.setter(Builder::endSessionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSessionEndpoint").build()}).build();
    private static final SdkField<String> LOGOUT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logoutEndpoint").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::logoutEndpoint)).setter(RegisterOidcConfigTestResponse.setter(Builder::logoutEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoutEndpoint").build()}).build();
    private static final SdkField<List<String>> GRANT_TYPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grantTypesSupported").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::grantTypesSupported)).setter(RegisterOidcConfigTestResponse.setter(Builder::grantTypesSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantTypesSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REVOCATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revocationEndpoint").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::revocationEndpoint)).setter(RegisterOidcConfigTestResponse.setter(Builder::revocationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationEndpoint").build()}).build();
    private static final SdkField<List<String>> TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tokenEndpointAuthMethodsSupported").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::tokenEndpointAuthMethodsSupported)).setter(RegisterOidcConfigTestResponse.setter(Builder::tokenEndpointAuthMethodsSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpointAuthMethodsSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MICROSOFT_MULTI_REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("microsoftMultiRefreshToken").getter(RegisterOidcConfigTestResponse.getter(RegisterOidcConfigTestResponse::microsoftMultiRefreshToken)).setter(RegisterOidcConfigTestResponse.setter(Builder::microsoftMultiRefreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("microsoftMultiRefreshToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ENDPOINT_FIELD, USERINFO_ENDPOINT_FIELD, RESPONSE_TYPES_SUPPORTED_FIELD, SCOPES_SUPPORTED_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, END_SESSION_ENDPOINT_FIELD, LOGOUT_ENDPOINT_FIELD, GRANT_TYPES_SUPPORTED_FIELD, REVOCATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED_FIELD, MICROSOFT_MULTI_REFRESH_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterOidcConfigTestResponse.memberNameToFieldInitializer();
    private final String tokenEndpoint;
    private final String userinfoEndpoint;
    private final List<String> responseTypesSupported;
    private final List<String> scopesSupported;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String endSessionEndpoint;
    private final String logoutEndpoint;
    private final List<String> grantTypesSupported;
    private final String revocationEndpoint;
    private final List<String> tokenEndpointAuthMethodsSupported;
    private final Boolean microsoftMultiRefreshToken;

    private RegisterOidcConfigTestResponse(BuilderImpl builder) {
        super(builder);
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userinfoEndpoint = builder.userinfoEndpoint;
        this.responseTypesSupported = builder.responseTypesSupported;
        this.scopesSupported = builder.scopesSupported;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.endSessionEndpoint = builder.endSessionEndpoint;
        this.logoutEndpoint = builder.logoutEndpoint;
        this.grantTypesSupported = builder.grantTypesSupported;
        this.revocationEndpoint = builder.revocationEndpoint;
        this.tokenEndpointAuthMethodsSupported = builder.tokenEndpointAuthMethodsSupported;
        this.microsoftMultiRefreshToken = builder.microsoftMultiRefreshToken;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final String userinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public final boolean hasResponseTypesSupported() {
        return this.responseTypesSupported != null && !(this.responseTypesSupported instanceof SdkAutoConstructList);
    }

    public final List<String> responseTypesSupported() {
        return this.responseTypesSupported;
    }

    public final boolean hasScopesSupported() {
        return this.scopesSupported != null && !(this.scopesSupported instanceof SdkAutoConstructList);
    }

    public final List<String> scopesSupported() {
        return this.scopesSupported;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String endSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public final String logoutEndpoint() {
        return this.logoutEndpoint;
    }

    public final boolean hasGrantTypesSupported() {
        return this.grantTypesSupported != null && !(this.grantTypesSupported instanceof SdkAutoConstructList);
    }

    public final List<String> grantTypesSupported() {
        return this.grantTypesSupported;
    }

    public final String revocationEndpoint() {
        return this.revocationEndpoint;
    }

    public final boolean hasTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported != null && !(this.tokenEndpointAuthMethodsSupported instanceof SdkAutoConstructList);
    }

    public final List<String> tokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    public final Boolean microsoftMultiRefreshToken() {
        return this.microsoftMultiRefreshToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.userinfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTypesSupported() ? this.responseTypesSupported() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopesSupported() ? this.scopesSupported() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endSessionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoutEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTypesSupported() ? this.grantTypesSupported() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenEndpointAuthMethodsSupported() ? this.tokenEndpointAuthMethodsSupported() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.microsoftMultiRefreshToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOidcConfigTestResponse)) {
            return false;
        }
        RegisterOidcConfigTestResponse other = (RegisterOidcConfigTestResponse)((Object)obj);
        return Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.userinfoEndpoint(), other.userinfoEndpoint()) && this.hasResponseTypesSupported() == other.hasResponseTypesSupported() && Objects.equals(this.responseTypesSupported(), other.responseTypesSupported()) && this.hasScopesSupported() == other.hasScopesSupported() && Objects.equals(this.scopesSupported(), other.scopesSupported()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.endSessionEndpoint(), other.endSessionEndpoint()) && Objects.equals(this.logoutEndpoint(), other.logoutEndpoint()) && this.hasGrantTypesSupported() == other.hasGrantTypesSupported() && Objects.equals(this.grantTypesSupported(), other.grantTypesSupported()) && Objects.equals(this.revocationEndpoint(), other.revocationEndpoint()) && this.hasTokenEndpointAuthMethodsSupported() == other.hasTokenEndpointAuthMethodsSupported() && Objects.equals(this.tokenEndpointAuthMethodsSupported(), other.tokenEndpointAuthMethodsSupported()) && Objects.equals(this.microsoftMultiRefreshToken(), other.microsoftMultiRefreshToken());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterOidcConfigTestResponse").add("TokenEndpoint", (Object)this.tokenEndpoint()).add("UserinfoEndpoint", (Object)this.userinfoEndpoint()).add("ResponseTypesSupported", this.hasResponseTypesSupported() ? this.responseTypesSupported() : null).add("ScopesSupported", this.hasScopesSupported() ? this.scopesSupported() : null).add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("EndSessionEndpoint", (Object)this.endSessionEndpoint()).add("LogoutEndpoint", (Object)this.logoutEndpoint()).add("GrantTypesSupported", this.hasGrantTypesSupported() ? this.grantTypesSupported() : null).add("RevocationEndpoint", (Object)this.revocationEndpoint()).add("TokenEndpointAuthMethodsSupported", this.hasTokenEndpointAuthMethodsSupported() ? this.tokenEndpointAuthMethodsSupported() : null).add("MicrosoftMultiRefreshToken", (Object)this.microsoftMultiRefreshToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "userinfoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.userinfoEndpoint()));
            }
            case "responseTypesSupported": {
                return Optional.ofNullable(clazz.cast(this.responseTypesSupported()));
            }
            case "scopesSupported": {
                return Optional.ofNullable(clazz.cast(this.scopesSupported()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "authorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "endSessionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.endSessionEndpoint()));
            }
            case "logoutEndpoint": {
                return Optional.ofNullable(clazz.cast(this.logoutEndpoint()));
            }
            case "grantTypesSupported": {
                return Optional.ofNullable(clazz.cast(this.grantTypesSupported()));
            }
            case "revocationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.revocationEndpoint()));
            }
            case "tokenEndpointAuthMethodsSupported": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpointAuthMethodsSupported()));
            }
            case "microsoftMultiRefreshToken": {
                return Optional.ofNullable(clazz.cast(this.microsoftMultiRefreshToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("userinfoEndpoint", USERINFO_ENDPOINT_FIELD);
        map.put("responseTypesSupported", RESPONSE_TYPES_SUPPORTED_FIELD);
        map.put("scopesSupported", SCOPES_SUPPORTED_FIELD);
        map.put("issuer", ISSUER_FIELD);
        map.put("authorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("endSessionEndpoint", END_SESSION_ENDPOINT_FIELD);
        map.put("logoutEndpoint", LOGOUT_ENDPOINT_FIELD);
        map.put("grantTypesSupported", GRANT_TYPES_SUPPORTED_FIELD);
        map.put("revocationEndpoint", REVOCATION_ENDPOINT_FIELD);
        map.put("tokenEndpointAuthMethodsSupported", TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED_FIELD);
        map.put("microsoftMultiRefreshToken", MICROSOFT_MULTI_REFRESH_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterOidcConfigTestResponse, T> g) {
        return obj -> g.apply((RegisterOidcConfigTestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String tokenEndpoint;
        private String userinfoEndpoint;
        private List<String> responseTypesSupported = DefaultSdkAutoConstructList.getInstance();
        private List<String> scopesSupported = DefaultSdkAutoConstructList.getInstance();
        private String issuer;
        private String authorizationEndpoint;
        private String endSessionEndpoint;
        private String logoutEndpoint;
        private List<String> grantTypesSupported = DefaultSdkAutoConstructList.getInstance();
        private String revocationEndpoint;
        private List<String> tokenEndpointAuthMethodsSupported = DefaultSdkAutoConstructList.getInstance();
        private Boolean microsoftMultiRefreshToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOidcConfigTestResponse model) {
            super(model);
            this.tokenEndpoint(model.tokenEndpoint);
            this.userinfoEndpoint(model.userinfoEndpoint);
            this.responseTypesSupported(model.responseTypesSupported);
            this.scopesSupported(model.scopesSupported);
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.endSessionEndpoint(model.endSessionEndpoint);
            this.logoutEndpoint(model.logoutEndpoint);
            this.grantTypesSupported(model.grantTypesSupported);
            this.revocationEndpoint(model.revocationEndpoint);
            this.tokenEndpointAuthMethodsSupported(model.tokenEndpointAuthMethodsSupported);
            this.microsoftMultiRefreshToken(model.microsoftMultiRefreshToken);
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserinfoEndpoint() {
            return this.userinfoEndpoint;
        }

        public final void setUserinfoEndpoint(String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
        }

        @Override
        public final Builder userinfoEndpoint(String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
            return this;
        }

        public final Collection<String> getResponseTypesSupported() {
            if (this.responseTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.responseTypesSupported;
        }

        public final void setResponseTypesSupported(Collection<String> responseTypesSupported) {
            this.responseTypesSupported = StringListCopier.copy(responseTypesSupported);
        }

        @Override
        public final Builder responseTypesSupported(Collection<String> responseTypesSupported) {
            this.responseTypesSupported = StringListCopier.copy(responseTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTypesSupported(String ... responseTypesSupported) {
            this.responseTypesSupported(Arrays.asList(responseTypesSupported));
            return this;
        }

        public final Collection<String> getScopesSupported() {
            if (this.scopesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopesSupported;
        }

        public final void setScopesSupported(Collection<String> scopesSupported) {
            this.scopesSupported = StringListCopier.copy(scopesSupported);
        }

        @Override
        public final Builder scopesSupported(Collection<String> scopesSupported) {
            this.scopesSupported = StringListCopier.copy(scopesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopesSupported(String ... scopesSupported) {
            this.scopesSupported(Arrays.asList(scopesSupported));
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getEndSessionEndpoint() {
            return this.endSessionEndpoint;
        }

        public final void setEndSessionEndpoint(String endSessionEndpoint) {
            this.endSessionEndpoint = endSessionEndpoint;
        }

        @Override
        public final Builder endSessionEndpoint(String endSessionEndpoint) {
            this.endSessionEndpoint = endSessionEndpoint;
            return this;
        }

        public final String getLogoutEndpoint() {
            return this.logoutEndpoint;
        }

        public final void setLogoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
        }

        @Override
        public final Builder logoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
            return this;
        }

        public final Collection<String> getGrantTypesSupported() {
            if (this.grantTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTypesSupported;
        }

        public final void setGrantTypesSupported(Collection<String> grantTypesSupported) {
            this.grantTypesSupported = StringListCopier.copy(grantTypesSupported);
        }

        @Override
        public final Builder grantTypesSupported(Collection<String> grantTypesSupported) {
            this.grantTypesSupported = StringListCopier.copy(grantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTypesSupported(String ... grantTypesSupported) {
            this.grantTypesSupported(Arrays.asList(grantTypesSupported));
            return this;
        }

        public final String getRevocationEndpoint() {
            return this.revocationEndpoint;
        }

        public final void setRevocationEndpoint(String revocationEndpoint) {
            this.revocationEndpoint = revocationEndpoint;
        }

        @Override
        public final Builder revocationEndpoint(String revocationEndpoint) {
            this.revocationEndpoint = revocationEndpoint;
            return this;
        }

        public final Collection<String> getTokenEndpointAuthMethodsSupported() {
            if (this.tokenEndpointAuthMethodsSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenEndpointAuthMethodsSupported;
        }

        public final void setTokenEndpointAuthMethodsSupported(Collection<String> tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported = StringListCopier.copy(tokenEndpointAuthMethodsSupported);
        }

        @Override
        public final Builder tokenEndpointAuthMethodsSupported(Collection<String> tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported = StringListCopier.copy(tokenEndpointAuthMethodsSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenEndpointAuthMethodsSupported(String ... tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported(Arrays.asList(tokenEndpointAuthMethodsSupported));
            return this;
        }

        public final Boolean getMicrosoftMultiRefreshToken() {
            return this.microsoftMultiRefreshToken;
        }

        public final void setMicrosoftMultiRefreshToken(Boolean microsoftMultiRefreshToken) {
            this.microsoftMultiRefreshToken = microsoftMultiRefreshToken;
        }

        @Override
        public final Builder microsoftMultiRefreshToken(Boolean microsoftMultiRefreshToken) {
            this.microsoftMultiRefreshToken = microsoftMultiRefreshToken;
            return this;
        }

        @Override
        public RegisterOidcConfigTestResponse build() {
            return new RegisterOidcConfigTestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterOidcConfigTestResponse> {
        public Builder tokenEndpoint(String var1);

        public Builder userinfoEndpoint(String var1);

        public Builder responseTypesSupported(Collection<String> var1);

        public Builder responseTypesSupported(String ... var1);

        public Builder scopesSupported(Collection<String> var1);

        public Builder scopesSupported(String ... var1);

        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder endSessionEndpoint(String var1);

        public Builder logoutEndpoint(String var1);

        public Builder grantTypesSupported(Collection<String> var1);

        public Builder grantTypesSupported(String ... var1);

        public Builder revocationEndpoint(String var1);

        public Builder tokenEndpointAuthMethodsSupported(Collection<String> var1);

        public Builder tokenEndpointAuthMethodsSupported(String ... var1);

        public Builder microsoftMultiRefreshToken(Boolean var1);
    }
}

