/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupsResponse;
import software.amazon.awssdk.services.wickr.model.SecurityGroup;

public class ListSecurityGroupsPublisher
implements SdkPublisher<ListSecurityGroupsResponse> {
    private final WickrAsyncClient client;
    private final ListSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityGroupsPublisher(WickrAsyncClient client, ListSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityGroupsPublisher(WickrAsyncClient client, ListSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityGroup> securityGroups() {
        Function<ListSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroups() != null) {
                return response.securityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<ListSecurityGroupsResponse> {
        private ListSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityGroupsResponse> nextPage(ListSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityGroupsPublisher.this.client.listSecurityGroups(ListSecurityGroupsPublisher.this.firstRequest);
            }
            return ListSecurityGroupsPublisher.this.client.listSecurityGroups((ListSecurityGroupsRequest)((Object)ListSecurityGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

