/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersResponse;
import software.amazon.awssdk.services.wickr.model.User;

public class ListSecurityGroupUsersIterable
implements SdkIterable<ListSecurityGroupUsersResponse> {
    private final WickrClient client;
    private final ListSecurityGroupUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityGroupUsersIterable(WickrClient client, ListSecurityGroupUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityGroupUsersResponseFetcher();
    }

    public Iterator<ListSecurityGroupUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<User> users() {
        Function<ListSecurityGroupUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityGroupUsersResponseFetcher
    implements SyncPageFetcher<ListSecurityGroupUsersResponse> {
        private ListSecurityGroupUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityGroupUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityGroupUsersResponse nextPage(ListSecurityGroupUsersResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityGroupUsersIterable.this.client.listSecurityGroupUsers(ListSecurityGroupUsersIterable.this.firstRequest);
            }
            return ListSecurityGroupUsersIterable.this.client.listSecurityGroupUsers((ListSecurityGroupUsersRequest)((Object)ListSecurityGroupUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

