/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.GuestUser;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListGuestUsersResponse;

public class ListGuestUsersIterable
implements SdkIterable<ListGuestUsersResponse> {
    private final WickrClient client;
    private final ListGuestUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGuestUsersIterable(WickrClient client, ListGuestUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGuestUsersResponseFetcher();
    }

    public Iterator<ListGuestUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GuestUser> guestlist() {
        Function<ListGuestUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.guestlist() != null) {
                return response.guestlist().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGuestUsersResponseFetcher
    implements SyncPageFetcher<ListGuestUsersResponse> {
        private ListGuestUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListGuestUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGuestUsersResponse nextPage(ListGuestUsersResponse previousPage) {
            if (previousPage == null) {
                return ListGuestUsersIterable.this.client.listGuestUsers(ListGuestUsersIterable.this.firstRequest);
            }
            return ListGuestUsersIterable.this.client.listGuestUsers((ListGuestUsersRequest)((Object)ListGuestUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

