/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.Bot;
import software.amazon.awssdk.services.wickr.model.ListBotsRequest;
import software.amazon.awssdk.services.wickr.model.ListBotsResponse;

public class ListBotsPublisher
implements SdkPublisher<ListBotsResponse> {
    private final WickrAsyncClient client;
    private final ListBotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotsPublisher(WickrAsyncClient client, ListBotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotsPublisher(WickrAsyncClient client, ListBotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Bot> bots() {
        Function<ListBotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.bots() != null) {
                return response.bots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBotsResponseFetcher
    implements AsyncPageFetcher<ListBotsResponse> {
        private ListBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotsResponse> nextPage(ListBotsResponse previousPage) {
            if (previousPage == null) {
                return ListBotsPublisher.this.client.listBots(ListBotsPublisher.this.firstRequest);
            }
            return ListBotsPublisher.this.client.listBots((ListBotsRequest)((Object)ListBotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

