/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.SecurityGroupSettings;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityGroupRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, UpdateSecurityGroupRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(UpdateSecurityGroupRequest.getter(UpdateSecurityGroupRequest::networkId)).setter(UpdateSecurityGroupRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(UpdateSecurityGroupRequest.getter(UpdateSecurityGroupRequest::groupId)).setter(UpdateSecurityGroupRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("groupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateSecurityGroupRequest.getter(UpdateSecurityGroupRequest::name)).setter(UpdateSecurityGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<SecurityGroupSettings> SECURITY_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("securityGroupSettings").getter(UpdateSecurityGroupRequest.getter(UpdateSecurityGroupRequest::securityGroupSettings)).setter(UpdateSecurityGroupRequest.setter(Builder::securityGroupSettings)).constructor(SecurityGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, GROUP_ID_FIELD, NAME_FIELD, SECURITY_GROUP_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSecurityGroupRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String groupId;
    private final String name;
    private final SecurityGroupSettings securityGroupSettings;

    private UpdateSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.groupId = builder.groupId;
        this.name = builder.name;
        this.securityGroupSettings = builder.securityGroupSettings;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String name() {
        return this.name;
    }

    public final SecurityGroupSettings securityGroupSettings() {
        return this.securityGroupSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRequest)) {
            return false;
        }
        UpdateSecurityGroupRequest other = (UpdateSecurityGroupRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.securityGroupSettings(), other.securityGroupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityGroupRequest").add("NetworkId", (Object)this.networkId()).add("GroupId", (Object)this.groupId()).add("Name", (Object)this.name()).add("SecurityGroupSettings", (Object)this.securityGroupSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "securityGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.securityGroupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("securityGroupSettings", SECURITY_GROUP_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityGroupRequest, T> g) {
        return obj -> g.apply((UpdateSecurityGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String groupId;
        private String name;
        private SecurityGroupSettings securityGroupSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityGroupRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.groupId(model.groupId);
            this.name(model.name);
            this.securityGroupSettings(model.securityGroupSettings);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SecurityGroupSettings.Builder getSecurityGroupSettings() {
            return this.securityGroupSettings != null ? this.securityGroupSettings.toBuilder() : null;
        }

        public final void setSecurityGroupSettings(SecurityGroupSettings.BuilderImpl securityGroupSettings) {
            this.securityGroupSettings = securityGroupSettings != null ? securityGroupSettings.build() : null;
        }

        @Override
        public final Builder securityGroupSettings(SecurityGroupSettings securityGroupSettings) {
            this.securityGroupSettings = securityGroupSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityGroupRequest build() {
            return new UpdateSecurityGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityGroupRequest> {
        public Builder networkId(String var1);

        public Builder groupId(String var1);

        public Builder name(String var1);

        public Builder securityGroupSettings(SecurityGroupSettings var1);

        default public Builder securityGroupSettings(Consumer<SecurityGroupSettings.Builder> securityGroupSettings) {
            return this.securityGroupSettings((SecurityGroupSettings)((SecurityGroupSettings.Builder)SecurityGroupSettings.builder().applyMutation(securityGroupSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

