/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.User;
import software.amazon.awssdk.services.wickr.model.UsersCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, ListUsersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUsersResponse.getter(ListUsersResponse::nextToken)).setter(ListUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<User>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("users").getter(ListUsersResponse.getter(ListUsersResponse::users)).setter(ListUsersResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, USERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<User> users;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.users = builder.users;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<User> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersResponse").add("NextToken", (Object)this.nextToken()).add("Users", this.hasUsers() ? this.users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("users", USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.users(model.users);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<User.Builder> getUsers() {
            List<User.Builder> result = UsersCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = UsersCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = UsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (User)((User.Builder)User.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersResponse> {
        public Builder nextToken(String var1);

        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder users(Consumer<User.Builder> ... var1);
    }
}

