/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.GuestUser;
import software.amazon.awssdk.services.wickr.model.GuestUserListCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGuestUsersResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, ListGuestUsersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGuestUsersResponse.getter(ListGuestUsersResponse::nextToken)).setter(ListGuestUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<GuestUser>> GUESTLIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("guestlist").getter(ListGuestUsersResponse.getter(ListGuestUsersResponse::guestlist)).setter(ListGuestUsersResponse.setter(Builder::guestlist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guestlist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuestUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, GUESTLIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGuestUsersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<GuestUser> guestlist;

    private ListGuestUsersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.guestlist = builder.guestlist;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasGuestlist() {
        return this.guestlist != null && !(this.guestlist instanceof SdkAutoConstructList);
    }

    public final List<GuestUser> guestlist() {
        return this.guestlist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuestlist() ? this.guestlist() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGuestUsersResponse)) {
            return false;
        }
        ListGuestUsersResponse other = (ListGuestUsersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasGuestlist() == other.hasGuestlist() && Objects.equals(this.guestlist(), other.guestlist());
    }

    public final String toString() {
        return ToString.builder((String)"ListGuestUsersResponse").add("NextToken", (Object)this.nextToken()).add("Guestlist", this.hasGuestlist() ? this.guestlist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "guestlist": {
                return Optional.ofNullable(clazz.cast(this.guestlist()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("guestlist", GUESTLIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGuestUsersResponse, T> g) {
        return obj -> g.apply((ListGuestUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<GuestUser> guestlist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGuestUsersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.guestlist(model.guestlist);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<GuestUser.Builder> getGuestlist() {
            List<GuestUser.Builder> result = GuestUserListCopier.copyToBuilder(this.guestlist);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGuestlist(Collection<GuestUser.BuilderImpl> guestlist) {
            this.guestlist = GuestUserListCopier.copyFromBuilder(guestlist);
        }

        @Override
        public final Builder guestlist(Collection<GuestUser> guestlist) {
            this.guestlist = GuestUserListCopier.copy(guestlist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guestlist(GuestUser ... guestlist) {
            this.guestlist(Arrays.asList(guestlist));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guestlist(Consumer<GuestUser.Builder> ... guestlist) {
            this.guestlist(Stream.of(guestlist).map(c -> (GuestUser)((GuestUser.Builder)GuestUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGuestUsersResponse build() {
            return new ListGuestUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGuestUsersResponse> {
        public Builder nextToken(String var1);

        public Builder guestlist(Collection<GuestUser> var1);

        public Builder guestlist(GuestUser ... var1);

        public Builder guestlist(Consumer<GuestUser.Builder> ... var1);
    }
}

