/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.BlockedGuestUser;
import software.amazon.awssdk.services.wickr.model.BlockedGuestUserListCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBlockedGuestUsersResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, ListBlockedGuestUsersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBlockedGuestUsersResponse.getter(ListBlockedGuestUsersResponse::nextToken)).setter(ListBlockedGuestUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<BlockedGuestUser>> BLOCKLIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blocklist").getter(ListBlockedGuestUsersResponse.getter(ListBlockedGuestUsersResponse::blocklist)).setter(ListBlockedGuestUsersResponse.setter(Builder::blocklist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocklist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockedGuestUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BLOCKLIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBlockedGuestUsersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<BlockedGuestUser> blocklist;

    private ListBlockedGuestUsersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.blocklist = builder.blocklist;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBlocklist() {
        return this.blocklist != null && !(this.blocklist instanceof SdkAutoConstructList);
    }

    public final List<BlockedGuestUser> blocklist() {
        return this.blocklist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlocklist() ? this.blocklist() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlockedGuestUsersResponse)) {
            return false;
        }
        ListBlockedGuestUsersResponse other = (ListBlockedGuestUsersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasBlocklist() == other.hasBlocklist() && Objects.equals(this.blocklist(), other.blocklist());
    }

    public final String toString() {
        return ToString.builder((String)"ListBlockedGuestUsersResponse").add("NextToken", (Object)this.nextToken()).add("Blocklist", this.hasBlocklist() ? this.blocklist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "blocklist": {
                return Optional.ofNullable(clazz.cast(this.blocklist()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("blocklist", BLOCKLIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlockedGuestUsersResponse, T> g) {
        return obj -> g.apply((ListBlockedGuestUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BlockedGuestUser> blocklist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlockedGuestUsersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.blocklist(model.blocklist);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BlockedGuestUser.Builder> getBlocklist() {
            List<BlockedGuestUser.Builder> result = BlockedGuestUserListCopier.copyToBuilder(this.blocklist);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocklist(Collection<BlockedGuestUser.BuilderImpl> blocklist) {
            this.blocklist = BlockedGuestUserListCopier.copyFromBuilder(blocklist);
        }

        @Override
        public final Builder blocklist(Collection<BlockedGuestUser> blocklist) {
            this.blocklist = BlockedGuestUserListCopier.copy(blocklist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocklist(BlockedGuestUser ... blocklist) {
            this.blocklist(Arrays.asList(blocklist));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocklist(Consumer<BlockedGuestUser.Builder> ... blocklist) {
            this.blocklist(Stream.of(blocklist).map(c -> (BlockedGuestUser)((BlockedGuestUser.Builder)BlockedGuestUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBlockedGuestUsersResponse build() {
            return new ListBlockedGuestUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBlockedGuestUsersResponse> {
        public Builder nextToken(String var1);

        public Builder blocklist(Collection<BlockedGuestUser> var1);

        public Builder blocklist(BlockedGuestUser ... var1);

        public Builder blocklist(Consumer<BlockedGuestUser.Builder> ... var1);
    }
}

