/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBotRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, CreateBotRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(CreateBotRequest.getter(CreateBotRequest::networkId)).setter(CreateBotRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(CreateBotRequest.getter(CreateBotRequest::username)).setter(CreateBotRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateBotRequest.getter(CreateBotRequest::displayName)).setter(CreateBotRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(CreateBotRequest.getter(CreateBotRequest::groupId)).setter(CreateBotRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()}).build();
    private static final SdkField<String> CHALLENGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("challenge").getter(CreateBotRequest.getter(CreateBotRequest::challenge)).setter(CreateBotRequest.setter(Builder::challenge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("challenge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, USERNAME_FIELD, DISPLAY_NAME_FIELD, GROUP_ID_FIELD, CHALLENGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBotRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String username;
    private final String displayName;
    private final String groupId;
    private final String challenge;

    private CreateBotRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.username = builder.username;
        this.displayName = builder.displayName;
        this.groupId = builder.groupId;
        this.challenge = builder.challenge;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String username() {
        return this.username;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String challenge() {
        return this.challenge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challenge());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotRequest)) {
            return false;
        }
        CreateBotRequest other = (CreateBotRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.challenge(), other.challenge());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBotRequest").add("NetworkId", (Object)this.networkId()).add("Username", (Object)this.username()).add("DisplayName", (Object)this.displayName()).add("GroupId", (Object)this.groupId()).add("Challenge", (Object)(this.challenge() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "challenge": {
                return Optional.ofNullable(clazz.cast(this.challenge()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        map.put("challenge", CHALLENGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotRequest, T> g) {
        return obj -> g.apply((CreateBotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String username;
        private String displayName;
        private String groupId;
        private String challenge;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.username(model.username);
            this.displayName(model.displayName);
            this.groupId(model.groupId);
            this.challenge(model.challenge);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getChallenge() {
            return this.challenge;
        }

        public final void setChallenge(String challenge) {
            this.challenge = challenge;
        }

        @Override
        public final Builder challenge(String challenge) {
            this.challenge = challenge;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBotRequest build() {
            return new CreateBotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBotRequest> {
        public Builder networkId(String var1);

        public Builder username(String var1);

        public Builder displayName(String var1);

        public Builder groupId(String var1);

        public Builder challenge(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

