/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse;

public class ListTemplateSharesIterable
implements SdkIterable<ListTemplateSharesResponse> {
    private final WellArchitectedClient client;
    private final ListTemplateSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateSharesIterable(WellArchitectedClient client, ListTemplateSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTemplateSharesResponseFetcher();
    }

    public Iterator<ListTemplateSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTemplateSharesResponseFetcher
    implements SyncPageFetcher<ListTemplateSharesResponse> {
        private ListTemplateSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateSharesResponse nextPage(ListTemplateSharesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateSharesIterable.this.client.listTemplateShares(ListTemplateSharesIterable.this.firstRequest);
            }
            return ListTemplateSharesIterable.this.client.listTemplateShares((ListTemplateSharesRequest)((Object)ListTemplateSharesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

