/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.VersionDifferences;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLensVersionDifferenceResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, GetLensVersionDifferenceResponse> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::lensAlias)).setter(GetLensVersionDifferenceResponse.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::lensArn)).setter(GetLensVersionDifferenceResponse.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> BASE_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseLensVersion").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::baseLensVersion)).setter(GetLensVersionDifferenceResponse.setter(Builder::baseLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLensVersion").build()}).build();
    private static final SdkField<String> TARGET_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLensVersion").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::targetLensVersion)).setter(GetLensVersionDifferenceResponse.setter(Builder::targetLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLensVersion").build()}).build();
    private static final SdkField<String> LATEST_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestLensVersion").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::latestLensVersion)).setter(GetLensVersionDifferenceResponse.setter(Builder::latestLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestLensVersion").build()}).build();
    private static final SdkField<VersionDifferences> VERSION_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VersionDifferences").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::versionDifferences)).setter(GetLensVersionDifferenceResponse.setter(Builder::versionDifferences)).constructor(VersionDifferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDifferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_ARN_FIELD, BASE_LENS_VERSION_FIELD, TARGET_LENS_VERSION_FIELD, LATEST_LENS_VERSION_FIELD, VERSION_DIFFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLensVersionDifferenceResponse.memberNameToFieldInitializer();
    private final String lensAlias;
    private final String lensArn;
    private final String baseLensVersion;
    private final String targetLensVersion;
    private final String latestLensVersion;
    private final VersionDifferences versionDifferences;

    private GetLensVersionDifferenceResponse(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.baseLensVersion = builder.baseLensVersion;
        this.targetLensVersion = builder.targetLensVersion;
        this.latestLensVersion = builder.latestLensVersion;
        this.versionDifferences = builder.versionDifferences;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String baseLensVersion() {
        return this.baseLensVersion;
    }

    public final String targetLensVersion() {
        return this.targetLensVersion;
    }

    public final String latestLensVersion() {
        return this.latestLensVersion;
    }

    public final VersionDifferences versionDifferences() {
        return this.versionDifferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDifferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensVersionDifferenceResponse)) {
            return false;
        }
        GetLensVersionDifferenceResponse other = (GetLensVersionDifferenceResponse)((Object)obj);
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.baseLensVersion(), other.baseLensVersion()) && Objects.equals(this.targetLensVersion(), other.targetLensVersion()) && Objects.equals(this.latestLensVersion(), other.latestLensVersion()) && Objects.equals(this.versionDifferences(), other.versionDifferences());
    }

    public final String toString() {
        return ToString.builder((String)"GetLensVersionDifferenceResponse").add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("BaseLensVersion", (Object)this.baseLensVersion()).add("TargetLensVersion", (Object)this.targetLensVersion()).add("LatestLensVersion", (Object)this.latestLensVersion()).add("VersionDifferences", (Object)this.versionDifferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "BaseLensVersion": {
                return Optional.ofNullable(clazz.cast(this.baseLensVersion()));
            }
            case "TargetLensVersion": {
                return Optional.ofNullable(clazz.cast(this.targetLensVersion()));
            }
            case "LatestLensVersion": {
                return Optional.ofNullable(clazz.cast(this.latestLensVersion()));
            }
            case "VersionDifferences": {
                return Optional.ofNullable(clazz.cast(this.versionDifferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("BaseLensVersion", BASE_LENS_VERSION_FIELD);
        map.put("TargetLensVersion", TARGET_LENS_VERSION_FIELD);
        map.put("LatestLensVersion", LATEST_LENS_VERSION_FIELD);
        map.put("VersionDifferences", VERSION_DIFFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLensVersionDifferenceResponse, T> g) {
        return obj -> g.apply((GetLensVersionDifferenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensArn;
        private String baseLensVersion;
        private String targetLensVersion;
        private String latestLensVersion;
        private VersionDifferences versionDifferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensVersionDifferenceResponse model) {
            super(model);
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.baseLensVersion(model.baseLensVersion);
            this.targetLensVersion(model.targetLensVersion);
            this.latestLensVersion(model.latestLensVersion);
            this.versionDifferences(model.versionDifferences);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getBaseLensVersion() {
            return this.baseLensVersion;
        }

        public final void setBaseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
        }

        @Override
        public final Builder baseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
            return this;
        }

        public final String getTargetLensVersion() {
            return this.targetLensVersion;
        }

        public final void setTargetLensVersion(String targetLensVersion) {
            this.targetLensVersion = targetLensVersion;
        }

        @Override
        public final Builder targetLensVersion(String targetLensVersion) {
            this.targetLensVersion = targetLensVersion;
            return this;
        }

        public final String getLatestLensVersion() {
            return this.latestLensVersion;
        }

        public final void setLatestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
        }

        @Override
        public final Builder latestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
            return this;
        }

        public final VersionDifferences.Builder getVersionDifferences() {
            return this.versionDifferences != null ? this.versionDifferences.toBuilder() : null;
        }

        public final void setVersionDifferences(VersionDifferences.BuilderImpl versionDifferences) {
            this.versionDifferences = versionDifferences != null ? versionDifferences.build() : null;
        }

        @Override
        public final Builder versionDifferences(VersionDifferences versionDifferences) {
            this.versionDifferences = versionDifferences;
            return this;
        }

        @Override
        public GetLensVersionDifferenceResponse build() {
            return new GetLensVersionDifferenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLensVersionDifferenceResponse> {
        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder baseLensVersion(String var1);

        public Builder targetLensVersion(String var1);

        public Builder latestLensVersion(String var1);

        public Builder versionDifferences(VersionDifferences var1);

        default public Builder versionDifferences(Consumer<VersionDifferences.Builder> versionDifferences) {
            return this.versionDifferences((VersionDifferences)((VersionDifferences.Builder)VersionDifferences.builder().applyMutation(versionDifferences)).build());
        }
    }
}

