/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.AccountSummaryCopier;
import software.amazon.awssdk.services.wellarchitected.model.CheckProvider;
import software.amazon.awssdk.services.wellarchitected.model.CheckStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CheckSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CheckSummary.getter(CheckSummary::id)).setter(CheckSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CheckSummary.getter(CheckSummary::name)).setter(CheckSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(CheckSummary.getter(CheckSummary::providerAsString)).setter(CheckSummary.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CheckSummary.getter(CheckSummary::description)).setter(CheckSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(CheckSummary.getter(CheckSummary::updatedAt)).setter(CheckSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(CheckSummary.getter(CheckSummary::lensArn)).setter(CheckSummary.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(CheckSummary.getter(CheckSummary::pillarId)).setter(CheckSummary.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(CheckSummary.getter(CheckSummary::questionId)).setter(CheckSummary.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChoiceId").getter(CheckSummary.getter(CheckSummary::choiceId)).setter(CheckSummary.setter(Builder::choiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CheckSummary.getter(CheckSummary::statusAsString)).setter(CheckSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, Integer>> ACCOUNT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AccountSummary").getter(CheckSummary.getter(CheckSummary::accountSummaryAsStrings)).setter(CheckSummary.setter(Builder::accountSummaryWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSummary").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, PROVIDER_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD, LENS_ARN_FIELD, PILLAR_ID_FIELD, QUESTION_ID_FIELD, CHOICE_ID_FIELD, STATUS_FIELD, ACCOUNT_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String provider;
    private final String description;
    private final Instant updatedAt;
    private final String lensArn;
    private final String pillarId;
    private final String questionId;
    private final String choiceId;
    private final String status;
    private final Map<String, Integer> accountSummary;

    private CheckSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.provider = builder.provider;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
        this.lensArn = builder.lensArn;
        this.pillarId = builder.pillarId;
        this.questionId = builder.questionId;
        this.choiceId = builder.choiceId;
        this.status = builder.status;
        this.accountSummary = builder.accountSummary;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final CheckProvider provider() {
        return CheckProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final String description() {
        return this.description;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String choiceId() {
        return this.choiceId;
    }

    public final CheckStatus status() {
        return CheckStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Map<CheckStatus, Integer> accountSummary() {
        return AccountSummaryCopier.copyStringToEnum(this.accountSummary);
    }

    public final boolean hasAccountSummary() {
        return this.accountSummary != null && !(this.accountSummary instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> accountSummaryAsStrings() {
        return this.accountSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountSummary() ? this.accountSummaryAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSummary)) {
            return false;
        }
        CheckSummary other = (CheckSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.choiceId(), other.choiceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAccountSummary() == other.hasAccountSummary() && Objects.equals(this.accountSummaryAsStrings(), other.accountSummaryAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CheckSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Provider", (Object)this.providerAsString()).add("Description", (Object)this.description()).add("UpdatedAt", (Object)this.updatedAt()).add("LensArn", (Object)this.lensArn()).add("PillarId", (Object)this.pillarId()).add("QuestionId", (Object)this.questionId()).add("ChoiceId", (Object)this.choiceId()).add("Status", (Object)this.statusAsString()).add("AccountSummary", this.hasAccountSummary() ? this.accountSummaryAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "ChoiceId": {
                return Optional.ofNullable(clazz.cast(this.choiceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AccountSummary": {
                return Optional.ofNullable(clazz.cast(this.accountSummaryAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccountSummary", ACCOUNT_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckSummary, T> g) {
        return obj -> g.apply((CheckSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String provider;
        private String description;
        private Instant updatedAt;
        private String lensArn;
        private String pillarId;
        private String questionId;
        private String choiceId;
        private String status;
        private Map<String, Integer> accountSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CheckSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.provider(model.provider);
            this.description(model.description);
            this.updatedAt(model.updatedAt);
            this.lensArn(model.lensArn);
            this.pillarId(model.pillarId);
            this.questionId(model.questionId);
            this.choiceId(model.choiceId);
            this.status(model.status);
            this.accountSummaryWithStrings(model.accountSummary);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(CheckProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getChoiceId() {
            return this.choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CheckStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, Integer> getAccountSummary() {
            if (this.accountSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.accountSummary;
        }

        public final void setAccountSummary(Map<String, Integer> accountSummary) {
            this.accountSummary = AccountSummaryCopier.copy(accountSummary);
        }

        @Override
        public final Builder accountSummaryWithStrings(Map<String, Integer> accountSummary) {
            this.accountSummary = AccountSummaryCopier.copy(accountSummary);
            return this;
        }

        @Override
        public final Builder accountSummary(Map<CheckStatus, Integer> accountSummary) {
            this.accountSummary = AccountSummaryCopier.copyEnumToString(accountSummary);
            return this;
        }

        public CheckSummary build() {
            return new CheckSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CheckSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder provider(CheckProvider var1);

        public Builder description(String var1);

        public Builder updatedAt(Instant var1);

        public Builder lensArn(String var1);

        public Builder pillarId(String var1);

        public Builder questionId(String var1);

        public Builder choiceId(String var1);

        public Builder status(String var1);

        public Builder status(CheckStatus var1);

        public Builder accountSummaryWithStrings(Map<String, Integer> var1);

        public Builder accountSummary(Map<CheckStatus, Integer> var1);
    }
}

