/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLensRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, GetLensRequest> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(GetLensRequest.getter(GetLensRequest::lensAlias)).setter(GetLensRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(GetLensRequest.getter(GetLensRequest::lensVersion)).setter(GetLensRequest.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLensRequest.memberNameToFieldInitializer();
    private final String lensAlias;
    private final String lensVersion;

    private GetLensRequest(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.lensVersion = builder.lensVersion;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensRequest)) {
            return false;
        }
        GetLensRequest other = (GetLensRequest)((Object)obj);
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensVersion(), other.lensVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetLensRequest").add("LensAlias", (Object)this.lensAlias()).add("LensVersion", (Object)this.lensVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensVersion", LENS_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLensRequest, T> g) {
        return obj -> g.apply((GetLensRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensRequest model) {
            super(model);
            this.lensAlias(model.lensAlias);
            this.lensVersion(model.lensVersion);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLensRequest build() {
            return new GetLensRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLensRequest> {
        public Builder lensAlias(String var1);

        public Builder lensVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

