/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ShareStatus;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadSharesRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, ListWorkloadSharesRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListWorkloadSharesRequest.getter(ListWorkloadSharesRequest::workloadId)).setter(ListWorkloadSharesRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> SHARED_WITH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedWithPrefix").getter(ListWorkloadSharesRequest.getter(ListWorkloadSharesRequest::sharedWithPrefix)).setter(ListWorkloadSharesRequest.setter(Builder::sharedWithPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SharedWithPrefix").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkloadSharesRequest.getter(ListWorkloadSharesRequest::nextToken)).setter(ListWorkloadSharesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListWorkloadSharesRequest.getter(ListWorkloadSharesRequest::maxResults)).setter(ListWorkloadSharesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListWorkloadSharesRequest.getter(ListWorkloadSharesRequest::statusAsString)).setter(ListWorkloadSharesRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, SHARED_WITH_PREFIX_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD));
    private final String workloadId;
    private final String sharedWithPrefix;
    private final String nextToken;
    private final Integer maxResults;
    private final String status;

    private ListWorkloadSharesRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.sharedWithPrefix = builder.sharedWithPrefix;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String sharedWithPrefix() {
        return this.sharedWithPrefix;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedWithPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadSharesRequest)) {
            return false;
        }
        ListWorkloadSharesRequest other = (ListWorkloadSharesRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.sharedWithPrefix(), other.sharedWithPrefix()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadSharesRequest").add("WorkloadId", (Object)this.workloadId()).add("SharedWithPrefix", (Object)this.sharedWithPrefix()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "SharedWithPrefix": {
                return Optional.ofNullable(clazz.cast(this.sharedWithPrefix()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadSharesRequest, T> g) {
        return obj -> g.apply((ListWorkloadSharesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String sharedWithPrefix;
        private String nextToken;
        private Integer maxResults;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadSharesRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.sharedWithPrefix(model.sharedWithPrefix);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.status(model.status);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getSharedWithPrefix() {
            return this.sharedWithPrefix;
        }

        public final void setSharedWithPrefix(String sharedWithPrefix) {
            this.sharedWithPrefix = sharedWithPrefix;
        }

        @Override
        public final Builder sharedWithPrefix(String sharedWithPrefix) {
            this.sharedWithPrefix = sharedWithPrefix;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkloadSharesRequest build() {
            return new ListWorkloadSharesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadSharesRequest> {
        public Builder workloadId(String var1);

        public Builder sharedWithPrefix(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

