/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse;

public class ListLensReviewImprovementsPublisher
implements SdkPublisher<ListLensReviewImprovementsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListLensReviewImprovementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLensReviewImprovementsPublisher(WellArchitectedAsyncClient client, ListLensReviewImprovementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLensReviewImprovementsPublisher(WellArchitectedAsyncClient client, ListLensReviewImprovementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLensReviewImprovementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLensReviewImprovementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLensReviewImprovementsResponseFetcher
    implements AsyncPageFetcher<ListLensReviewImprovementsResponse> {
        private ListLensReviewImprovementsResponseFetcher() {
        }

        public boolean hasNextPage(ListLensReviewImprovementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLensReviewImprovementsResponse> nextPage(ListLensReviewImprovementsResponse previousPage) {
            if (previousPage == null) {
                return ListLensReviewImprovementsPublisher.this.client.listLensReviewImprovements(ListLensReviewImprovementsPublisher.this.firstRequest);
            }
            return ListLensReviewImprovementsPublisher.this.client.listLensReviewImprovements((ListLensReviewImprovementsRequest)((Object)ListLensReviewImprovementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

