/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.wellarchitected.DefaultWellArchitectedBaseClientBuilder;
import software.amazon.awssdk.services.wellarchitected.DefaultWellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClientBuilder;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedServiceClientConfiguration;
import software.amazon.awssdk.services.wellarchitected.endpoints.WellArchitectedEndpointProvider;

@SdkInternalApi
final class DefaultWellArchitectedClientBuilder
extends DefaultWellArchitectedBaseClientBuilder<WellArchitectedClientBuilder, WellArchitectedClient>
implements WellArchitectedClientBuilder {
    DefaultWellArchitectedClientBuilder() {
    }

    @Override
    public DefaultWellArchitectedClientBuilder endpointProvider(WellArchitectedEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WellArchitectedClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWellArchitectedClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WellArchitectedServiceClientConfiguration serviceClientConfiguration = WellArchitectedServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWellArchitectedClient(serviceClientConfiguration, clientConfiguration);
    }
}

