/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse;

public class GetConsolidatedReportPublisher
implements SdkPublisher<GetConsolidatedReportResponse> {
    private final WellArchitectedAsyncClient client;
    private final GetConsolidatedReportRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetConsolidatedReportPublisher(WellArchitectedAsyncClient client, GetConsolidatedReportRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetConsolidatedReportPublisher(WellArchitectedAsyncClient client, GetConsolidatedReportRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetConsolidatedReportResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetConsolidatedReportResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetConsolidatedReportResponseFetcher
    implements AsyncPageFetcher<GetConsolidatedReportResponse> {
        private GetConsolidatedReportResponseFetcher() {
        }

        public boolean hasNextPage(GetConsolidatedReportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetConsolidatedReportResponse> nextPage(GetConsolidatedReportResponse previousPage) {
            if (previousPage == null) {
                return GetConsolidatedReportPublisher.this.client.getConsolidatedReport(GetConsolidatedReportPublisher.this.firstRequest);
            }
            return GetConsolidatedReportPublisher.this.client.getConsolidatedReport((GetConsolidatedReportRequest)((Object)GetConsolidatedReportPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

