/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.services.wellarchitected.model.TagMapCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadAccountIdsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadAwsRegionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadEnvironment;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadImprovementStatus;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadLensesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadNonAwsRegionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadPillarPrioritiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workload> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(Workload.getter(Workload::workloadId)).setter(Workload.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadArn").getter(Workload.getter(Workload::workloadArn)).setter(Workload.setter(Builder::workloadArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadArn").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(Workload.getter(Workload::workloadName)).setter(Workload.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Workload.getter(Workload::description)).setter(Workload.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Environment").getter(Workload.getter(Workload::environmentAsString)).setter(Workload.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Workload.getter(Workload::updatedAt)).setter(Workload.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(Workload.getter(Workload::accountIds)).setter(Workload.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsRegions").getter(Workload.getter(Workload::awsRegions)).setter(Workload.setter(Builder::awsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NON_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonAwsRegions").getter(Workload.getter(Workload::nonAwsRegions)).setter(Workload.setter(Builder::nonAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARCHITECTURAL_DESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchitecturalDesign").getter(Workload.getter(Workload::architecturalDesign)).setter(Workload.setter(Builder::architecturalDesign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitecturalDesign").build()}).build();
    private static final SdkField<String> REVIEW_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewOwner").getter(Workload.getter(Workload::reviewOwner)).setter(Workload.setter(Builder::reviewOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewOwner").build()}).build();
    private static final SdkField<Instant> REVIEW_RESTRICTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReviewRestrictionDate").getter(Workload.getter(Workload::reviewRestrictionDate)).setter(Workload.setter(Builder::reviewRestrictionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewRestrictionDate").build()}).build();
    private static final SdkField<Boolean> IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsReviewOwnerUpdateAcknowledged").getter(Workload.getter(Workload::isReviewOwnerUpdateAcknowledged)).setter(Workload.setter(Builder::isReviewOwnerUpdateAcknowledged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReviewOwnerUpdateAcknowledged").build()}).build();
    private static final SdkField<String> INDUSTRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndustryType").getter(Workload.getter(Workload::industryType)).setter(Workload.setter(Builder::industryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustryType").build()}).build();
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(Workload.getter(Workload::industry)).setter(Workload.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(Workload.getter(Workload::notes)).setter(Workload.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> IMPROVEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImprovementStatus").getter(Workload.getter(Workload::improvementStatusAsString)).setter(Workload.setter(Builder::improvementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(Workload.getter(Workload::riskCountsAsStrings)).setter(Workload.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PILLAR_PRIORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PillarPriorities").getter(Workload.getter(Workload::pillarPriorities)).setter(Workload.setter(Builder::pillarPriorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarPriorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lenses").getter(Workload.getter(Workload::lenses)).setter(Workload.setter(Builder::lenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(Workload.getter(Workload::owner)).setter(Workload.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareInvitationId").getter(Workload.getter(Workload::shareInvitationId)).setter(Workload.setter(Builder::shareInvitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Workload.getter(Workload::tags)).setter(Workload.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_ARN_FIELD, WORKLOAD_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_FIELD, UPDATED_AT_FIELD, ACCOUNT_IDS_FIELD, AWS_REGIONS_FIELD, NON_AWS_REGIONS_FIELD, ARCHITECTURAL_DESIGN_FIELD, REVIEW_OWNER_FIELD, REVIEW_RESTRICTION_DATE_FIELD, IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD, INDUSTRY_TYPE_FIELD, INDUSTRY_FIELD, NOTES_FIELD, IMPROVEMENT_STATUS_FIELD, RISK_COUNTS_FIELD, PILLAR_PRIORITIES_FIELD, LENSES_FIELD, OWNER_FIELD, SHARE_INVITATION_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workloadId;
    private final String workloadArn;
    private final String workloadName;
    private final String description;
    private final String environment;
    private final Instant updatedAt;
    private final List<String> accountIds;
    private final List<String> awsRegions;
    private final List<String> nonAwsRegions;
    private final String architecturalDesign;
    private final String reviewOwner;
    private final Instant reviewRestrictionDate;
    private final Boolean isReviewOwnerUpdateAcknowledged;
    private final String industryType;
    private final String industry;
    private final String notes;
    private final String improvementStatus;
    private final Map<String, Integer> riskCounts;
    private final List<String> pillarPriorities;
    private final List<String> lenses;
    private final String owner;
    private final String shareInvitationId;
    private final Map<String, String> tags;

    private Workload(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadArn = builder.workloadArn;
        this.workloadName = builder.workloadName;
        this.description = builder.description;
        this.environment = builder.environment;
        this.updatedAt = builder.updatedAt;
        this.accountIds = builder.accountIds;
        this.awsRegions = builder.awsRegions;
        this.nonAwsRegions = builder.nonAwsRegions;
        this.architecturalDesign = builder.architecturalDesign;
        this.reviewOwner = builder.reviewOwner;
        this.reviewRestrictionDate = builder.reviewRestrictionDate;
        this.isReviewOwnerUpdateAcknowledged = builder.isReviewOwnerUpdateAcknowledged;
        this.industryType = builder.industryType;
        this.industry = builder.industry;
        this.notes = builder.notes;
        this.improvementStatus = builder.improvementStatus;
        this.riskCounts = builder.riskCounts;
        this.pillarPriorities = builder.pillarPriorities;
        this.lenses = builder.lenses;
        this.owner = builder.owner;
        this.shareInvitationId = builder.shareInvitationId;
        this.tags = builder.tags;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String workloadArn() {
        return this.workloadArn;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String description() {
        return this.description;
    }

    public final WorkloadEnvironment environment() {
        return WorkloadEnvironment.fromValue(this.environment);
    }

    public final String environmentAsString() {
        return this.environment;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasAwsRegions() {
        return this.awsRegions != null && !(this.awsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> awsRegions() {
        return this.awsRegions;
    }

    public final boolean hasNonAwsRegions() {
        return this.nonAwsRegions != null && !(this.nonAwsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> nonAwsRegions() {
        return this.nonAwsRegions;
    }

    public final String architecturalDesign() {
        return this.architecturalDesign;
    }

    public final String reviewOwner() {
        return this.reviewOwner;
    }

    public final Instant reviewRestrictionDate() {
        return this.reviewRestrictionDate;
    }

    public final Boolean isReviewOwnerUpdateAcknowledged() {
        return this.isReviewOwnerUpdateAcknowledged;
    }

    public final String industryType() {
        return this.industryType;
    }

    public final String industry() {
        return this.industry;
    }

    public final String notes() {
        return this.notes;
    }

    public final WorkloadImprovementStatus improvementStatus() {
        return WorkloadImprovementStatus.fromValue(this.improvementStatus);
    }

    public final String improvementStatusAsString() {
        return this.improvementStatus;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public final boolean hasPillarPriorities() {
        return this.pillarPriorities != null && !(this.pillarPriorities instanceof SdkAutoConstructList);
    }

    public final List<String> pillarPriorities() {
        return this.pillarPriorities;
    }

    public final boolean hasLenses() {
        return this.lenses != null && !(this.lenses instanceof SdkAutoConstructList);
    }

    public final List<String> lenses() {
        return this.lenses;
    }

    public final String owner() {
        return this.owner;
    }

    public final String shareInvitationId() {
        return this.shareInvitationId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsRegions() ? this.awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonAwsRegions() ? this.nonAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.architecturalDesign());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewRestrictionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.isReviewOwnerUpdateAcknowledged());
        hashCode = 31 * hashCode + Objects.hashCode(this.industryType());
        hashCode = 31 * hashCode + Objects.hashCode(this.industry());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarPriorities() ? this.pillarPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLenses() ? this.lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workload)) {
            return false;
        }
        Workload other = (Workload)obj;
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadArn(), other.workloadArn()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentAsString(), other.environmentAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasAwsRegions() == other.hasAwsRegions() && Objects.equals(this.awsRegions(), other.awsRegions()) && this.hasNonAwsRegions() == other.hasNonAwsRegions() && Objects.equals(this.nonAwsRegions(), other.nonAwsRegions()) && Objects.equals(this.architecturalDesign(), other.architecturalDesign()) && Objects.equals(this.reviewOwner(), other.reviewOwner()) && Objects.equals(this.reviewRestrictionDate(), other.reviewRestrictionDate()) && Objects.equals(this.isReviewOwnerUpdateAcknowledged(), other.isReviewOwnerUpdateAcknowledged()) && Objects.equals(this.industryType(), other.industryType()) && Objects.equals(this.industry(), other.industry()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.improvementStatusAsString(), other.improvementStatusAsString()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && this.hasPillarPriorities() == other.hasPillarPriorities() && Objects.equals(this.pillarPriorities(), other.pillarPriorities()) && this.hasLenses() == other.hasLenses() && Objects.equals(this.lenses(), other.lenses()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.shareInvitationId(), other.shareInvitationId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Workload").add("WorkloadId", (Object)this.workloadId()).add("WorkloadArn", (Object)this.workloadArn()).add("WorkloadName", (Object)this.workloadName()).add("Description", (Object)this.description()).add("Environment", (Object)this.environmentAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AwsRegions", this.hasAwsRegions() ? this.awsRegions() : null).add("NonAwsRegions", this.hasNonAwsRegions() ? this.nonAwsRegions() : null).add("ArchitecturalDesign", (Object)this.architecturalDesign()).add("ReviewOwner", (Object)this.reviewOwner()).add("ReviewRestrictionDate", (Object)this.reviewRestrictionDate()).add("IsReviewOwnerUpdateAcknowledged", (Object)this.isReviewOwnerUpdateAcknowledged()).add("IndustryType", (Object)this.industryType()).add("Industry", (Object)this.industry()).add("Notes", (Object)this.notes()).add("ImprovementStatus", (Object)this.improvementStatusAsString()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("PillarPriorities", this.hasPillarPriorities() ? this.pillarPriorities() : null).add("Lenses", this.hasLenses() ? this.lenses() : null).add("Owner", (Object)this.owner()).add("ShareInvitationId", (Object)this.shareInvitationId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadArn": {
                return Optional.ofNullable(clazz.cast(this.workloadArn()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environmentAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
            case "NonAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.nonAwsRegions()));
            }
            case "ArchitecturalDesign": {
                return Optional.ofNullable(clazz.cast(this.architecturalDesign()));
            }
            case "ReviewOwner": {
                return Optional.ofNullable(clazz.cast(this.reviewOwner()));
            }
            case "ReviewRestrictionDate": {
                return Optional.ofNullable(clazz.cast(this.reviewRestrictionDate()));
            }
            case "IsReviewOwnerUpdateAcknowledged": {
                return Optional.ofNullable(clazz.cast(this.isReviewOwnerUpdateAcknowledged()));
            }
            case "IndustryType": {
                return Optional.ofNullable(clazz.cast(this.industryType()));
            }
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industry()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "ImprovementStatus": {
                return Optional.ofNullable(clazz.cast(this.improvementStatusAsString()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "PillarPriorities": {
                return Optional.ofNullable(clazz.cast(this.pillarPriorities()));
            }
            case "Lenses": {
                return Optional.ofNullable(clazz.cast(this.lenses()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "ShareInvitationId": {
                return Optional.ofNullable(clazz.cast(this.shareInvitationId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workload, T> g) {
        return obj -> g.apply((Workload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workloadId;
        private String workloadArn;
        private String workloadName;
        private String description;
        private String environment;
        private Instant updatedAt;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> nonAwsRegions = DefaultSdkAutoConstructList.getInstance();
        private String architecturalDesign;
        private String reviewOwner;
        private Instant reviewRestrictionDate;
        private Boolean isReviewOwnerUpdateAcknowledged;
        private String industryType;
        private String industry;
        private String notes;
        private String improvementStatus;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private List<String> pillarPriorities = DefaultSdkAutoConstructList.getInstance();
        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private String shareInvitationId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workload model) {
            this.workloadId(model.workloadId);
            this.workloadArn(model.workloadArn);
            this.workloadName(model.workloadName);
            this.description(model.description);
            this.environment(model.environment);
            this.updatedAt(model.updatedAt);
            this.accountIds(model.accountIds);
            this.awsRegions(model.awsRegions);
            this.nonAwsRegions(model.nonAwsRegions);
            this.architecturalDesign(model.architecturalDesign);
            this.reviewOwner(model.reviewOwner);
            this.reviewRestrictionDate(model.reviewRestrictionDate);
            this.isReviewOwnerUpdateAcknowledged(model.isReviewOwnerUpdateAcknowledged);
            this.industryType(model.industryType);
            this.industry(model.industry);
            this.notes(model.notes);
            this.improvementStatus(model.improvementStatus);
            this.riskCountsWithStrings(model.riskCounts);
            this.pillarPriorities(model.pillarPriorities);
            this.lenses(model.lenses);
            this.owner(model.owner);
            this.shareInvitationId(model.shareInvitationId);
            this.tags(model.tags);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        @Transient
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadArn() {
            return this.workloadArn;
        }

        public final void setWorkloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
        }

        @Override
        @Transient
        public final Builder workloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        @Transient
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironment() {
            return this.environment;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        @Override
        @Transient
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        @Transient
        public final Builder environment(WorkloadEnvironment environment) {
            this.environment(environment == null ? null : environment.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
        }

        @Override
        @Transient
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getAwsRegions() {
            if (this.awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsRegions;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
        }

        @Override
        @Transient
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final Collection<String> getNonAwsRegions() {
            if (this.nonAwsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonAwsRegions;
        }

        public final void setNonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
        }

        @Override
        @Transient
        public final Builder nonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nonAwsRegions(String ... nonAwsRegions) {
            this.nonAwsRegions(Arrays.asList(nonAwsRegions));
            return this;
        }

        public final String getArchitecturalDesign() {
            return this.architecturalDesign;
        }

        public final void setArchitecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
        }

        @Override
        @Transient
        public final Builder architecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
            return this;
        }

        public final String getReviewOwner() {
            return this.reviewOwner;
        }

        public final void setReviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
        }

        @Override
        @Transient
        public final Builder reviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
            return this;
        }

        public final Instant getReviewRestrictionDate() {
            return this.reviewRestrictionDate;
        }

        public final void setReviewRestrictionDate(Instant reviewRestrictionDate) {
            this.reviewRestrictionDate = reviewRestrictionDate;
        }

        @Override
        @Transient
        public final Builder reviewRestrictionDate(Instant reviewRestrictionDate) {
            this.reviewRestrictionDate = reviewRestrictionDate;
            return this;
        }

        public final Boolean getIsReviewOwnerUpdateAcknowledged() {
            return this.isReviewOwnerUpdateAcknowledged;
        }

        public final void setIsReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
        }

        @Override
        @Transient
        public final Builder isReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
            return this;
        }

        public final String getIndustryType() {
            return this.industryType;
        }

        public final void setIndustryType(String industryType) {
            this.industryType = industryType;
        }

        @Override
        @Transient
        public final Builder industryType(String industryType) {
            this.industryType = industryType;
            return this;
        }

        public final String getIndustry() {
            return this.industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        @Transient
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        @Transient
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getImprovementStatus() {
            return this.improvementStatus;
        }

        public final void setImprovementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
        }

        @Override
        @Transient
        public final Builder improvementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder improvementStatus(WorkloadImprovementStatus improvementStatus) {
            this.improvementStatus(improvementStatus == null ? null : improvementStatus.toString());
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        @Transient
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        @Transient
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final Collection<String> getPillarPriorities() {
            if (this.pillarPriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pillarPriorities;
        }

        public final void setPillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
        }

        @Override
        @Transient
        public final Builder pillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pillarPriorities(String ... pillarPriorities) {
            this.pillarPriorities(Arrays.asList(pillarPriorities));
            return this;
        }

        public final Collection<String> getLenses() {
            if (this.lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
        }

        @Override
        @Transient
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lenses(String ... lenses) {
            this.lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getShareInvitationId() {
            return this.shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        @Transient
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Workload build() {
            return new Workload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workload> {
        public Builder workloadId(String var1);

        public Builder workloadArn(String var1);

        public Builder workloadName(String var1);

        public Builder description(String var1);

        public Builder environment(String var1);

        public Builder environment(WorkloadEnvironment var1);

        public Builder updatedAt(Instant var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);

        public Builder nonAwsRegions(Collection<String> var1);

        public Builder nonAwsRegions(String ... var1);

        public Builder architecturalDesign(String var1);

        public Builder reviewOwner(String var1);

        public Builder reviewRestrictionDate(Instant var1);

        public Builder isReviewOwnerUpdateAcknowledged(Boolean var1);

        public Builder industryType(String var1);

        public Builder industry(String var1);

        public Builder notes(String var1);

        public Builder improvementStatus(String var1);

        public Builder improvementStatus(WorkloadImprovementStatus var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder pillarPriorities(Collection<String> var1);

        public Builder pillarPriorities(String ... var1);

        public Builder lenses(Collection<String> var1);

        public Builder lenses(String ... var1);

        public Builder owner(String var1);

        public Builder shareInvitationId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

