/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse;

public class ListNotificationsIterable
implements SdkIterable<ListNotificationsResponse> {
    private final WellArchitectedClient client;
    private final ListNotificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationsIterable(WellArchitectedClient client, ListNotificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNotificationsResponseFetcher();
    }

    public Iterator<ListNotificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNotificationsResponseFetcher
    implements SyncPageFetcher<ListNotificationsResponse> {
        private ListNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationsResponse nextPage(ListNotificationsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationsIterable.this.client.listNotifications(ListNotificationsIterable.this.firstRequest);
            }
            return ListNotificationsIterable.this.client.listNotifications((ListNotificationsRequest)((Object)ListNotificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

