/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to update answer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnswerRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateAnswerRequest.Builder, UpdateAnswerRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(UpdateAnswerRequest::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(UpdateAnswerRequest::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()).build();

    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(UpdateAnswerRequest::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuestionId").build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoices")
            .getter(getter(UpdateAnswerRequest::selectedChoices))
            .setter(setter(Builder::selectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(UpdateAnswerRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsApplicable").getter(getter(UpdateAnswerRequest::isApplicable)).setter(setter(Builder::isApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            LENS_ALIAS_FIELD, QUESTION_ID_FIELD, SELECTED_CHOICES_FIELD, NOTES_FIELD, IS_APPLICABLE_FIELD));

    private final String workloadId;

    private final String lensAlias;

    private final String questionId;

    private final List<String> selectedChoices;

    private final String notes;

    private final Boolean isApplicable;

    private UpdateAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAlias = builder.lensAlias;
        this.questionId = builder.questionId;
        this.selectedChoices = builder.selectedChoices;
        this.notes = builder.notes;
        this.isApplicable = builder.isApplicable;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns true if the SelectedChoices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSelectedChoices() {
        return selectedChoices != null && !(selectedChoices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SelectedChoices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSelectedChoices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the SelectedChoices property for this object.
     */
    public final List<String> selectedChoices() {
        return selectedChoices;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * Returns the value of the IsApplicable property for this object.
     * 
     * @return The value of the IsApplicable property for this object.
     */
    public final Boolean isApplicable() {
        return isApplicable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoices() ? selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(isApplicable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnswerRequest)) {
            return false;
        }
        UpdateAnswerRequest other = (UpdateAnswerRequest) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(lensAlias(), other.lensAlias())
                && Objects.equals(questionId(), other.questionId()) && hasSelectedChoices() == other.hasSelectedChoices()
                && Objects.equals(selectedChoices(), other.selectedChoices()) && Objects.equals(notes(), other.notes())
                && Objects.equals(isApplicable(), other.isApplicable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnswerRequest").add("WorkloadId", workloadId()).add("LensAlias", lensAlias())
                .add("QuestionId", questionId()).add("SelectedChoices", hasSelectedChoices() ? selectedChoices() : null)
                .add("Notes", notes()).add("IsApplicable", isApplicable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "SelectedChoices":
            return Optional.ofNullable(clazz.cast(selectedChoices()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "IsApplicable":
            return Optional.ofNullable(clazz.cast(isApplicable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnswerRequest, T> g) {
        return obj -> g.apply((UpdateAnswerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAnswerRequest> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(Collection<String> selectedChoices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(String... selectedChoices);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * Sets the value of the IsApplicable property for this object.
         *
         * @param isApplicable
         *        The new value for the IsApplicable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isApplicable(Boolean isApplicable);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String workloadId;

        private String lensAlias;

        private String questionId;

        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();

        private String notes;

        private Boolean isApplicable;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnswerRequest model) {
            super(model);
            workloadId(model.workloadId);
            lensAlias(model.lensAlias);
            questionId(model.questionId);
            selectedChoices(model.selectedChoices);
            notes(model.notes);
            isApplicable(model.isApplicable);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getQuestionId() {
            return questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final Collection<String> getSelectedChoices() {
            if (selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoices;
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String... selectedChoices) {
            selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        public final String getNotes() {
            return notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public final Boolean getIsApplicable() {
            return isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnswerRequest build() {
            return new UpdateAnswerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
