/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A question difference return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuestionDifference implements SdkPojo, Serializable,
        ToCopyableBuilder<QuestionDifference.Builder, QuestionDifference> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(QuestionDifference::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionTitle").getter(getter(QuestionDifference::questionTitle)).setter(setter(Builder::questionTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()).build();

    private static final SdkField<String> DIFFERENCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DifferenceStatus").getter(getter(QuestionDifference::differenceStatusAsString))
            .setter(setter(Builder::differenceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DifferenceStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            QUESTION_TITLE_FIELD, DIFFERENCE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String questionTitle;

    private final String differenceStatus;

    private QuestionDifference(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.questionTitle = builder.questionTitle;
        this.differenceStatus = builder.differenceStatus;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the QuestionTitle property for this object.
     * 
     * @return The value of the QuestionTitle property for this object.
     */
    public final String questionTitle() {
        return questionTitle;
    }

    /**
     * <p>
     * Indicates the type of change to the question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #differenceStatus}
     * will return {@link DifferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #differenceStatusAsString}.
     * </p>
     * 
     * @return Indicates the type of change to the question.
     * @see DifferenceStatus
     */
    public final DifferenceStatus differenceStatus() {
        return DifferenceStatus.fromValue(differenceStatus);
    }

    /**
     * <p>
     * Indicates the type of change to the question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #differenceStatus}
     * will return {@link DifferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #differenceStatusAsString}.
     * </p>
     * 
     * @return Indicates the type of change to the question.
     * @see DifferenceStatus
     */
    public final String differenceStatusAsString() {
        return differenceStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(differenceStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuestionDifference)) {
            return false;
        }
        QuestionDifference other = (QuestionDifference) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(questionTitle(), other.questionTitle())
                && Objects.equals(differenceStatusAsString(), other.differenceStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuestionDifference").add("QuestionId", questionId()).add("QuestionTitle", questionTitle())
                .add("DifferenceStatus", differenceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "QuestionTitle":
            return Optional.ofNullable(clazz.cast(questionTitle()));
        case "DifferenceStatus":
            return Optional.ofNullable(clazz.cast(differenceStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuestionDifference, T> g) {
        return obj -> g.apply((QuestionDifference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuestionDifference> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the QuestionTitle property for this object.
         *
         * @param questionTitle
         *        The new value for the QuestionTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTitle(String questionTitle);

        /**
         * <p>
         * Indicates the type of change to the question.
         * </p>
         * 
         * @param differenceStatus
         *        Indicates the type of change to the question.
         * @see DifferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceStatus
         */
        Builder differenceStatus(String differenceStatus);

        /**
         * <p>
         * Indicates the type of change to the question.
         * </p>
         * 
         * @param differenceStatus
         *        Indicates the type of change to the question.
         * @see DifferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceStatus
         */
        Builder differenceStatus(DifferenceStatus differenceStatus);
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String questionTitle;

        private String differenceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(QuestionDifference model) {
            questionId(model.questionId);
            questionTitle(model.questionTitle);
            differenceStatus(model.differenceStatus);
        }

        public final String getQuestionId() {
            return questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getQuestionTitle() {
            return questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        public final String getDifferenceStatus() {
            return differenceStatus;
        }

        @Override
        public final Builder differenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
            return this;
        }

        @Override
        public final Builder differenceStatus(DifferenceStatus differenceStatus) {
            this.differenceStatus(differenceStatus == null ? null : differenceStatus.toString());
            return this;
        }

        public final void setDifferenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
        }

        @Override
        public QuestionDifference build() {
            return new QuestionDifference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
