/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationsResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListNotificationsResponse.Builder, ListNotificationsResponse> {
    private static final SdkField<List<NotificationSummary>> NOTIFICATION_SUMMARIES_FIELD = SdkField
            .<List<NotificationSummary>> builder(MarshallingType.LIST)
            .memberName("NotificationSummaries")
            .getter(getter(ListNotificationsResponse::notificationSummaries))
            .setter(setter(Builder::notificationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNotificationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NotificationSummary> notificationSummaries;

    private final String nextToken;

    private ListNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.notificationSummaries = builder.notificationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the NotificationSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNotificationSummaries() {
        return notificationSummaries != null && !(notificationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of lens notification summaries in a workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of lens notification summaries in a workload.
     */
    public final List<NotificationSummary> notificationSummaries() {
        return notificationSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationSummaries() ? notificationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsResponse)) {
            return false;
        }
        ListNotificationsResponse other = (ListNotificationsResponse) obj;
        return hasNotificationSummaries() == other.hasNotificationSummaries()
                && Objects.equals(notificationSummaries(), other.notificationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationsResponse")
                .add("NotificationSummaries", hasNotificationSummaries() ? notificationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationSummaries":
            return Optional.ofNullable(clazz.cast(notificationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationsResponse, T> g) {
        return obj -> g.apply((ListNotificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationsResponse> {
        /**
         * <p>
         * List of lens notification summaries in a workload.
         * </p>
         * 
         * @param notificationSummaries
         *        List of lens notification summaries in a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSummaries(Collection<NotificationSummary> notificationSummaries);

        /**
         * <p>
         * List of lens notification summaries in a workload.
         * </p>
         * 
         * @param notificationSummaries
         *        List of lens notification summaries in a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSummaries(NotificationSummary... notificationSummaries);

        /**
         * <p>
         * List of lens notification summaries in a workload.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotificationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<NotificationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotificationSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationSummaries(List<NotificationSummary>)}.
         * 
         * @param notificationSummaries
         *        a consumer that will call methods on {@link List<NotificationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationSummaries(List<NotificationSummary>)
         */
        Builder notificationSummaries(Consumer<NotificationSummary.Builder>... notificationSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private List<NotificationSummary> notificationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationsResponse model) {
            super(model);
            notificationSummaries(model.notificationSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<NotificationSummary.Builder> getNotificationSummaries() {
            if (notificationSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationSummaries != null ? notificationSummaries.stream().map(NotificationSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationSummaries(Collection<NotificationSummary> notificationSummaries) {
            this.notificationSummaries = NotificationSummariesCopier.copy(notificationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSummaries(NotificationSummary... notificationSummaries) {
            notificationSummaries(Arrays.asList(notificationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSummaries(Consumer<NotificationSummary.Builder>... notificationSummaries) {
            notificationSummaries(Stream.of(notificationSummaries)
                    .map(c -> NotificationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotificationSummaries(Collection<NotificationSummary.BuilderImpl> notificationSummaries) {
            this.notificationSummaries = NotificationSummariesCopier.copyFromBuilder(notificationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNotificationsResponse build() {
            return new ListNotificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
