/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output of a list lens reviews call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLensReviewsResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListLensReviewsResponse.Builder, ListLensReviewsResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ListLensReviewsResponse::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MilestoneNumber").getter(getter(ListLensReviewsResponse::milestoneNumber))
            .setter(setter(Builder::milestoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()).build();

    private static final SdkField<List<LensReviewSummary>> LENS_REVIEW_SUMMARIES_FIELD = SdkField
            .<List<LensReviewSummary>> builder(MarshallingType.LIST)
            .memberName("LensReviewSummaries")
            .getter(getter(ListLensReviewsResponse::lensReviewSummaries))
            .setter(setter(Builder::lensReviewSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensReviewSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LensReviewSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LensReviewSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLensReviewsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            MILESTONE_NUMBER_FIELD, LENS_REVIEW_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String workloadId;

    private final Integer milestoneNumber;

    private final List<LensReviewSummary> lensReviewSummaries;

    private final String nextToken;

    private ListLensReviewsResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensReviewSummaries = builder.lensReviewSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the MilestoneNumber property for this object.
     * 
     * @return The value of the MilestoneNumber property for this object.
     */
    public final Integer milestoneNumber() {
        return milestoneNumber;
    }

    /**
     * Returns true if the LensReviewSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLensReviewSummaries() {
        return lensReviewSummaries != null && !(lensReviewSummaries instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the LensReviewSummaries property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLensReviewSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the LensReviewSummaries property for this object.
     */
    public final List<LensReviewSummary> lensReviewSummaries() {
        return lensReviewSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasLensReviewSummaries() ? lensReviewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensReviewsResponse)) {
            return false;
        }
        ListLensReviewsResponse other = (ListLensReviewsResponse) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(milestoneNumber(), other.milestoneNumber())
                && hasLensReviewSummaries() == other.hasLensReviewSummaries()
                && Objects.equals(lensReviewSummaries(), other.lensReviewSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLensReviewsResponse").add("WorkloadId", workloadId())
                .add("MilestoneNumber", milestoneNumber())
                .add("LensReviewSummaries", hasLensReviewSummaries() ? lensReviewSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "MilestoneNumber":
            return Optional.ofNullable(clazz.cast(milestoneNumber()));
        case "LensReviewSummaries":
            return Optional.ofNullable(clazz.cast(lensReviewSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLensReviewsResponse, T> g) {
        return obj -> g.apply((ListLensReviewsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLensReviewsResponse> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the MilestoneNumber property for this object.
         *
         * @param milestoneNumber
         *        The new value for the MilestoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneNumber(Integer milestoneNumber);

        /**
         * Sets the value of the LensReviewSummaries property for this object.
         *
         * @param lensReviewSummaries
         *        The new value for the LensReviewSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensReviewSummaries(Collection<LensReviewSummary> lensReviewSummaries);

        /**
         * Sets the value of the LensReviewSummaries property for this object.
         *
         * @param lensReviewSummaries
         *        The new value for the LensReviewSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensReviewSummaries(LensReviewSummary... lensReviewSummaries);

        /**
         * Sets the value of the LensReviewSummaries property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<LensReviewSummary>.Builder} avoiding the
         * need to create one manually via {@link List<LensReviewSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LensReviewSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #lensReviewSummaries(List<LensReviewSummary>)}.
         * 
         * @param lensReviewSummaries
         *        a consumer that will call methods on {@link List<LensReviewSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lensReviewSummaries(List<LensReviewSummary>)
         */
        Builder lensReviewSummaries(Consumer<LensReviewSummary.Builder>... lensReviewSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String workloadId;

        private Integer milestoneNumber;

        private List<LensReviewSummary> lensReviewSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensReviewsResponse model) {
            super(model);
            workloadId(model.workloadId);
            milestoneNumber(model.milestoneNumber);
            lensReviewSummaries(model.lensReviewSummaries);
            nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Integer getMilestoneNumber() {
            return milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        public final Collection<LensReviewSummary.Builder> getLensReviewSummaries() {
            if (lensReviewSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return lensReviewSummaries != null ? lensReviewSummaries.stream().map(LensReviewSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lensReviewSummaries(Collection<LensReviewSummary> lensReviewSummaries) {
            this.lensReviewSummaries = LensReviewSummariesCopier.copy(lensReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensReviewSummaries(LensReviewSummary... lensReviewSummaries) {
            lensReviewSummaries(Arrays.asList(lensReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensReviewSummaries(Consumer<LensReviewSummary.Builder>... lensReviewSummaries) {
            lensReviewSummaries(Stream.of(lensReviewSummaries).map(c -> LensReviewSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLensReviewSummaries(Collection<LensReviewSummary.BuilderImpl> lensReviewSummaries) {
            this.lensReviewSummaries = LensReviewSummariesCopier.copyFromBuilder(lensReviewSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLensReviewsResponse build() {
            return new ListLensReviewsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
