/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output of a list answers call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnswersResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListAnswersResponse.Builder, ListAnswersResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ListAnswersResponse::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MilestoneNumber").getter(getter(ListAnswersResponse::milestoneNumber))
            .setter(setter(Builder::milestoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(ListAnswersResponse::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<List<AnswerSummary>> ANSWER_SUMMARIES_FIELD = SdkField
            .<List<AnswerSummary>> builder(MarshallingType.LIST)
            .memberName("AnswerSummaries")
            .getter(getter(ListAnswersResponse::answerSummaries))
            .setter(setter(Builder::answerSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnswerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnswerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnswersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            MILESTONE_NUMBER_FIELD, LENS_ALIAS_FIELD, ANSWER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String workloadId;

    private final Integer milestoneNumber;

    private final String lensAlias;

    private final List<AnswerSummary> answerSummaries;

    private final String nextToken;

    private ListAnswersResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensAlias = builder.lensAlias;
        this.answerSummaries = builder.answerSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the MilestoneNumber property for this object.
     * 
     * @return The value of the MilestoneNumber property for this object.
     */
    public final Integer milestoneNumber() {
        return milestoneNumber;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * Returns true if the AnswerSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAnswerSummaries() {
        return answerSummaries != null && !(answerSummaries instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AnswerSummaries property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnswerSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AnswerSummaries property for this object.
     */
    public final List<AnswerSummary> answerSummaries() {
        return answerSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswerSummaries() ? answerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnswersResponse)) {
            return false;
        }
        ListAnswersResponse other = (ListAnswersResponse) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(milestoneNumber(), other.milestoneNumber())
                && Objects.equals(lensAlias(), other.lensAlias()) && hasAnswerSummaries() == other.hasAnswerSummaries()
                && Objects.equals(answerSummaries(), other.answerSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnswersResponse").add("WorkloadId", workloadId()).add("MilestoneNumber", milestoneNumber())
                .add("LensAlias", lensAlias()).add("AnswerSummaries", hasAnswerSummaries() ? answerSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "MilestoneNumber":
            return Optional.ofNullable(clazz.cast(milestoneNumber()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "AnswerSummaries":
            return Optional.ofNullable(clazz.cast(answerSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnswersResponse, T> g) {
        return obj -> g.apply((ListAnswersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAnswersResponse> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the MilestoneNumber property for this object.
         *
         * @param milestoneNumber
         *        The new value for the MilestoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneNumber(Integer milestoneNumber);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * Sets the value of the AnswerSummaries property for this object.
         *
         * @param answerSummaries
         *        The new value for the AnswerSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerSummaries(Collection<AnswerSummary> answerSummaries);

        /**
         * Sets the value of the AnswerSummaries property for this object.
         *
         * @param answerSummaries
         *        The new value for the AnswerSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerSummaries(AnswerSummary... answerSummaries);

        /**
         * Sets the value of the AnswerSummaries property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<AnswerSummary>.Builder} avoiding the need
         * to create one manually via {@link List<AnswerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnswerSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #answerSummaries(List<AnswerSummary>)}.
         * 
         * @param answerSummaries
         *        a consumer that will call methods on {@link List<AnswerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerSummaries(List<AnswerSummary>)
         */
        Builder answerSummaries(Consumer<AnswerSummary.Builder>... answerSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String workloadId;

        private Integer milestoneNumber;

        private String lensAlias;

        private List<AnswerSummary> answerSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnswersResponse model) {
            super(model);
            workloadId(model.workloadId);
            milestoneNumber(model.milestoneNumber);
            lensAlias(model.lensAlias);
            answerSummaries(model.answerSummaries);
            nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Integer getMilestoneNumber() {
            return milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final Collection<AnswerSummary.Builder> getAnswerSummaries() {
            if (answerSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return answerSummaries != null ? answerSummaries.stream().map(AnswerSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder answerSummaries(Collection<AnswerSummary> answerSummaries) {
            this.answerSummaries = AnswerSummariesCopier.copy(answerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(AnswerSummary... answerSummaries) {
            answerSummaries(Arrays.asList(answerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(Consumer<AnswerSummary.Builder>... answerSummaries) {
            answerSummaries(Stream.of(answerSummaries).map(c -> AnswerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAnswerSummaries(Collection<AnswerSummary.BuilderImpl> answerSummaries) {
            this.answerSummaries = AnswerSummariesCopier.copyFromBuilder(answerSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAnswersResponse build() {
            return new ListAnswersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
