/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLensVersionDifferenceResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetLensVersionDifferenceResponse.Builder, GetLensVersionDifferenceResponse> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(GetLensVersionDifferenceResponse::lensAlias))
            .setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> BASE_LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseLensVersion").getter(getter(GetLensVersionDifferenceResponse::baseLensVersion))
            .setter(setter(Builder::baseLensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLensVersion").build()).build();

    private static final SdkField<String> LATEST_LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestLensVersion").getter(getter(GetLensVersionDifferenceResponse::latestLensVersion))
            .setter(setter(Builder::latestLensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestLensVersion").build()).build();

    private static final SdkField<VersionDifferences> VERSION_DIFFERENCES_FIELD = SdkField
            .<VersionDifferences> builder(MarshallingType.SDK_POJO).memberName("VersionDifferences")
            .getter(getter(GetLensVersionDifferenceResponse::versionDifferences)).setter(setter(Builder::versionDifferences))
            .constructor(VersionDifferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDifferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD,
            BASE_LENS_VERSION_FIELD, LATEST_LENS_VERSION_FIELD, VERSION_DIFFERENCES_FIELD));

    private final String lensAlias;

    private final String baseLensVersion;

    private final String latestLensVersion;

    private final VersionDifferences versionDifferences;

    private GetLensVersionDifferenceResponse(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.baseLensVersion = builder.baseLensVersion;
        this.latestLensVersion = builder.latestLensVersion;
        this.versionDifferences = builder.versionDifferences;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The base version of the lens.
     * </p>
     * 
     * @return The base version of the lens.
     */
    public final String baseLensVersion() {
        return baseLensVersion;
    }

    /**
     * <p>
     * The latest version of the lens.
     * </p>
     * 
     * @return The latest version of the lens.
     */
    public final String latestLensVersion() {
        return latestLensVersion;
    }

    /**
     * Returns the value of the VersionDifferences property for this object.
     * 
     * @return The value of the VersionDifferences property for this object.
     */
    public final VersionDifferences versionDifferences() {
        return versionDifferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(baseLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionDifferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensVersionDifferenceResponse)) {
            return false;
        }
        GetLensVersionDifferenceResponse other = (GetLensVersionDifferenceResponse) obj;
        return Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(baseLensVersion(), other.baseLensVersion())
                && Objects.equals(latestLensVersion(), other.latestLensVersion())
                && Objects.equals(versionDifferences(), other.versionDifferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLensVersionDifferenceResponse").add("LensAlias", lensAlias())
                .add("BaseLensVersion", baseLensVersion()).add("LatestLensVersion", latestLensVersion())
                .add("VersionDifferences", versionDifferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "BaseLensVersion":
            return Optional.ofNullable(clazz.cast(baseLensVersion()));
        case "LatestLensVersion":
            return Optional.ofNullable(clazz.cast(latestLensVersion()));
        case "VersionDifferences":
            return Optional.ofNullable(clazz.cast(versionDifferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLensVersionDifferenceResponse, T> g) {
        return obj -> g.apply((GetLensVersionDifferenceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLensVersionDifferenceResponse> {
        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The base version of the lens.
         * </p>
         * 
         * @param baseLensVersion
         *        The base version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseLensVersion(String baseLensVersion);

        /**
         * <p>
         * The latest version of the lens.
         * </p>
         * 
         * @param latestLensVersion
         *        The latest version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestLensVersion(String latestLensVersion);

        /**
         * Sets the value of the VersionDifferences property for this object.
         *
         * @param versionDifferences
         *        The new value for the VersionDifferences property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDifferences(VersionDifferences versionDifferences);

        /**
         * Sets the value of the VersionDifferences property for this object.
         *
         * This is a convenience that creates an instance of the {@link VersionDifferences.Builder} avoiding the need to
         * create one manually via {@link VersionDifferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link VersionDifferences.Builder#build()} is called immediately and its
         * result is passed to {@link #versionDifferences(VersionDifferences)}.
         * 
         * @param versionDifferences
         *        a consumer that will call methods on {@link VersionDifferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionDifferences(VersionDifferences)
         */
        default Builder versionDifferences(Consumer<VersionDifferences.Builder> versionDifferences) {
            return versionDifferences(VersionDifferences.builder().applyMutation(versionDifferences).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String lensAlias;

        private String baseLensVersion;

        private String latestLensVersion;

        private VersionDifferences versionDifferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensVersionDifferenceResponse model) {
            super(model);
            lensAlias(model.lensAlias);
            baseLensVersion(model.baseLensVersion);
            latestLensVersion(model.latestLensVersion);
            versionDifferences(model.versionDifferences);
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getBaseLensVersion() {
            return baseLensVersion;
        }

        @Override
        public final Builder baseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
            return this;
        }

        public final void setBaseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
        }

        public final String getLatestLensVersion() {
            return latestLensVersion;
        }

        @Override
        public final Builder latestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
            return this;
        }

        public final void setLatestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
        }

        public final VersionDifferences.Builder getVersionDifferences() {
            return versionDifferences != null ? versionDifferences.toBuilder() : null;
        }

        @Override
        public final Builder versionDifferences(VersionDifferences versionDifferences) {
            this.versionDifferences = versionDifferences;
            return this;
        }

        public final void setVersionDifferences(VersionDifferences.BuilderImpl versionDifferences) {
            this.versionDifferences = versionDifferences != null ? versionDifferences.build() : null;
        }

        @Override
        public GetLensVersionDifferenceResponse build() {
            return new GetLensVersionDifferenceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
