/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for workload creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkloadRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<CreateWorkloadRequest.Builder, CreateWorkloadRequest> {
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(CreateWorkloadRequest::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateWorkloadRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Environment").getter(getter(CreateWorkloadRequest::environmentAsString))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(CreateWorkloadRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsRegions")
            .getter(getter(CreateWorkloadRequest::awsRegions))
            .setter(setter(Builder::awsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NON_AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NonAwsRegions")
            .getter(getter(CreateWorkloadRequest::nonAwsRegions))
            .setter(setter(Builder::nonAwsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PILLAR_PRIORITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PillarPriorities")
            .getter(getter(CreateWorkloadRequest::pillarPriorities))
            .setter(setter(Builder::pillarPriorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarPriorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARCHITECTURAL_DESIGN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchitecturalDesign").getter(getter(CreateWorkloadRequest::architecturalDesign))
            .setter(setter(Builder::architecturalDesign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitecturalDesign").build())
            .build();

    private static final SdkField<String> REVIEW_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewOwner").getter(getter(CreateWorkloadRequest::reviewOwner)).setter(setter(Builder::reviewOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewOwner").build()).build();

    private static final SdkField<String> INDUSTRY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndustryType").getter(getter(CreateWorkloadRequest::industryType)).setter(setter(Builder::industryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustryType").build()).build();

    private static final SdkField<String> INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Industry").getter(getter(CreateWorkloadRequest::industry)).setter(setter(Builder::industry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()).build();

    private static final SdkField<List<String>> LENSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Lenses")
            .getter(getter(CreateWorkloadRequest::lenses))
            .setter(setter(Builder::lenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(CreateWorkloadRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateWorkloadRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_NAME_FIELD,
            DESCRIPTION_FIELD, ENVIRONMENT_FIELD, ACCOUNT_IDS_FIELD, AWS_REGIONS_FIELD, NON_AWS_REGIONS_FIELD,
            PILLAR_PRIORITIES_FIELD, ARCHITECTURAL_DESIGN_FIELD, REVIEW_OWNER_FIELD, INDUSTRY_TYPE_FIELD, INDUSTRY_FIELD,
            LENSES_FIELD, NOTES_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String workloadName;

    private final String description;

    private final String environment;

    private final List<String> accountIds;

    private final List<String> awsRegions;

    private final List<String> nonAwsRegions;

    private final List<String> pillarPriorities;

    private final String architecturalDesign;

    private final String reviewOwner;

    private final String industryType;

    private final String industry;

    private final List<String> lenses;

    private final String notes;

    private final String clientRequestToken;

    private CreateWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.workloadName = builder.workloadName;
        this.description = builder.description;
        this.environment = builder.environment;
        this.accountIds = builder.accountIds;
        this.awsRegions = builder.awsRegions;
        this.nonAwsRegions = builder.nonAwsRegions;
        this.pillarPriorities = builder.pillarPriorities;
        this.architecturalDesign = builder.architecturalDesign;
        this.reviewOwner = builder.reviewOwner;
        this.industryType = builder.industryType;
        this.industry = builder.industry;
        this.lenses = builder.lenses;
        this.notes = builder.notes;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Environment property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environment} will
     * return {@link WorkloadEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentAsString}.
     * </p>
     * 
     * @return The value of the Environment property for this object.
     * @see WorkloadEnvironment
     */
    public final WorkloadEnvironment environment() {
        return WorkloadEnvironment.fromValue(environment);
    }

    /**
     * Returns the value of the Environment property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environment} will
     * return {@link WorkloadEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentAsString}.
     * </p>
     * 
     * @return The value of the Environment property for this object.
     * @see WorkloadEnvironment
     */
    public final String environmentAsString() {
        return environment;
    }

    /**
     * Returns true if the AccountIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AccountIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AccountIds property for this object.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * Returns true if the AwsRegions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAwsRegions() {
        return awsRegions != null && !(awsRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AwsRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAwsRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AwsRegions property for this object.
     */
    public final List<String> awsRegions() {
        return awsRegions;
    }

    /**
     * Returns true if the NonAwsRegions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasNonAwsRegions() {
        return nonAwsRegions != null && !(nonAwsRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the NonAwsRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNonAwsRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the NonAwsRegions property for this object.
     */
    public final List<String> nonAwsRegions() {
        return nonAwsRegions;
    }

    /**
     * Returns true if the PillarPriorities property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPillarPriorities() {
        return pillarPriorities != null && !(pillarPriorities instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the PillarPriorities property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPillarPriorities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the PillarPriorities property for this object.
     */
    public final List<String> pillarPriorities() {
        return pillarPriorities;
    }

    /**
     * Returns the value of the ArchitecturalDesign property for this object.
     * 
     * @return The value of the ArchitecturalDesign property for this object.
     */
    public final String architecturalDesign() {
        return architecturalDesign;
    }

    /**
     * Returns the value of the ReviewOwner property for this object.
     * 
     * @return The value of the ReviewOwner property for this object.
     */
    public final String reviewOwner() {
        return reviewOwner;
    }

    /**
     * Returns the value of the IndustryType property for this object.
     * 
     * @return The value of the IndustryType property for this object.
     */
    public final String industryType() {
        return industryType;
    }

    /**
     * Returns the value of the Industry property for this object.
     * 
     * @return The value of the Industry property for this object.
     */
    public final String industry() {
        return industry;
    }

    /**
     * Returns true if the Lenses property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLenses() {
        return lenses != null && !(lenses instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Lenses property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLenses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Lenses property for this object.
     */
    public final List<String> lenses() {
        return lenses;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsRegions() ? awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNonAwsRegions() ? nonAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPillarPriorities() ? pillarPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(architecturalDesign());
        hashCode = 31 * hashCode + Objects.hashCode(reviewOwner());
        hashCode = 31 * hashCode + Objects.hashCode(industryType());
        hashCode = 31 * hashCode + Objects.hashCode(industry());
        hashCode = 31 * hashCode + Objects.hashCode(hasLenses() ? lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadRequest)) {
            return false;
        }
        CreateWorkloadRequest other = (CreateWorkloadRequest) obj;
        return Objects.equals(workloadName(), other.workloadName()) && Objects.equals(description(), other.description())
                && Objects.equals(environmentAsString(), other.environmentAsString()) && hasAccountIds() == other.hasAccountIds()
                && Objects.equals(accountIds(), other.accountIds()) && hasAwsRegions() == other.hasAwsRegions()
                && Objects.equals(awsRegions(), other.awsRegions()) && hasNonAwsRegions() == other.hasNonAwsRegions()
                && Objects.equals(nonAwsRegions(), other.nonAwsRegions()) && hasPillarPriorities() == other.hasPillarPriorities()
                && Objects.equals(pillarPriorities(), other.pillarPriorities())
                && Objects.equals(architecturalDesign(), other.architecturalDesign())
                && Objects.equals(reviewOwner(), other.reviewOwner()) && Objects.equals(industryType(), other.industryType())
                && Objects.equals(industry(), other.industry()) && hasLenses() == other.hasLenses()
                && Objects.equals(lenses(), other.lenses()) && Objects.equals(notes(), other.notes())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkloadRequest").add("WorkloadName", workloadName()).add("Description", description())
                .add("Environment", environmentAsString()).add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("AwsRegions", hasAwsRegions() ? awsRegions() : null)
                .add("NonAwsRegions", hasNonAwsRegions() ? nonAwsRegions() : null)
                .add("PillarPriorities", hasPillarPriorities() ? pillarPriorities() : null)
                .add("ArchitecturalDesign", architecturalDesign()).add("ReviewOwner", reviewOwner())
                .add("IndustryType", industryType()).add("Industry", industry()).add("Lenses", hasLenses() ? lenses() : null)
                .add("Notes", notes()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environmentAsString()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "AwsRegions":
            return Optional.ofNullable(clazz.cast(awsRegions()));
        case "NonAwsRegions":
            return Optional.ofNullable(clazz.cast(nonAwsRegions()));
        case "PillarPriorities":
            return Optional.ofNullable(clazz.cast(pillarPriorities()));
        case "ArchitecturalDesign":
            return Optional.ofNullable(clazz.cast(architecturalDesign()));
        case "ReviewOwner":
            return Optional.ofNullable(clazz.cast(reviewOwner()));
        case "IndustryType":
            return Optional.ofNullable(clazz.cast(industryType()));
        case "Industry":
            return Optional.ofNullable(clazz.cast(industry()));
        case "Lenses":
            return Optional.ofNullable(clazz.cast(lenses()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadRequest, T> g) {
        return obj -> g.apply((CreateWorkloadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkloadRequest> {
        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @see WorkloadEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEnvironment
         */
        Builder environment(String environment);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @see WorkloadEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEnvironment
         */
        Builder environment(WorkloadEnvironment environment);

        /**
         * Sets the value of the AccountIds property for this object.
         *
         * @param accountIds
         *        The new value for the AccountIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * Sets the value of the AccountIds property for this object.
         *
         * @param accountIds
         *        The new value for the AccountIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * Sets the value of the AwsRegions property for this object.
         *
         * @param awsRegions
         *        The new value for the AwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(Collection<String> awsRegions);

        /**
         * Sets the value of the AwsRegions property for this object.
         *
         * @param awsRegions
         *        The new value for the AwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(String... awsRegions);

        /**
         * Sets the value of the NonAwsRegions property for this object.
         *
         * @param nonAwsRegions
         *        The new value for the NonAwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAwsRegions(Collection<String> nonAwsRegions);

        /**
         * Sets the value of the NonAwsRegions property for this object.
         *
         * @param nonAwsRegions
         *        The new value for the NonAwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAwsRegions(String... nonAwsRegions);

        /**
         * Sets the value of the PillarPriorities property for this object.
         *
         * @param pillarPriorities
         *        The new value for the PillarPriorities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarPriorities(Collection<String> pillarPriorities);

        /**
         * Sets the value of the PillarPriorities property for this object.
         *
         * @param pillarPriorities
         *        The new value for the PillarPriorities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarPriorities(String... pillarPriorities);

        /**
         * Sets the value of the ArchitecturalDesign property for this object.
         *
         * @param architecturalDesign
         *        The new value for the ArchitecturalDesign property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturalDesign(String architecturalDesign);

        /**
         * Sets the value of the ReviewOwner property for this object.
         *
         * @param reviewOwner
         *        The new value for the ReviewOwner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewOwner(String reviewOwner);

        /**
         * Sets the value of the IndustryType property for this object.
         *
         * @param industryType
         *        The new value for the IndustryType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder industryType(String industryType);

        /**
         * Sets the value of the Industry property for this object.
         *
         * @param industry
         *        The new value for the Industry property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder industry(String industry);

        /**
         * Sets the value of the Lenses property for this object.
         *
         * @param lenses
         *        The new value for the Lenses property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(Collection<String> lenses);

        /**
         * Sets the value of the Lenses property for this object.
         *
         * @param lenses
         *        The new value for the Lenses property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(String... lenses);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String workloadName;

        private String description;

        private String environment;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> nonAwsRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> pillarPriorities = DefaultSdkAutoConstructList.getInstance();

        private String architecturalDesign;

        private String reviewOwner;

        private String industryType;

        private String industry;

        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();

        private String notes;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadRequest model) {
            super(model);
            workloadName(model.workloadName);
            description(model.description);
            environment(model.environment);
            accountIds(model.accountIds);
            awsRegions(model.awsRegions);
            nonAwsRegions(model.nonAwsRegions);
            pillarPriorities(model.pillarPriorities);
            architecturalDesign(model.architecturalDesign);
            reviewOwner(model.reviewOwner);
            industryType(model.industryType);
            industry(model.industry);
            lenses(model.lenses);
            notes(model.notes);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public final Builder environment(WorkloadEnvironment environment) {
            this.environment(environment == null ? null : environment.toString());
            return this;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
        }

        public final Collection<String> getAwsRegions() {
            if (awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return awsRegions;
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String... awsRegions) {
            awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
        }

        public final Collection<String> getNonAwsRegions() {
            if (nonAwsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return nonAwsRegions;
        }

        @Override
        public final Builder nonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonAwsRegions(String... nonAwsRegions) {
            nonAwsRegions(Arrays.asList(nonAwsRegions));
            return this;
        }

        public final void setNonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
        }

        public final Collection<String> getPillarPriorities() {
            if (pillarPriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return pillarPriorities;
        }

        @Override
        public final Builder pillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarPriorities(String... pillarPriorities) {
            pillarPriorities(Arrays.asList(pillarPriorities));
            return this;
        }

        public final void setPillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
        }

        public final String getArchitecturalDesign() {
            return architecturalDesign;
        }

        @Override
        public final Builder architecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
            return this;
        }

        public final void setArchitecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
        }

        public final String getReviewOwner() {
            return reviewOwner;
        }

        @Override
        public final Builder reviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
            return this;
        }

        public final void setReviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
        }

        public final String getIndustryType() {
            return industryType;
        }

        @Override
        public final Builder industryType(String industryType) {
            this.industryType = industryType;
            return this;
        }

        public final void setIndustryType(String industryType) {
            this.industryType = industryType;
        }

        public final String getIndustry() {
            return industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        public final Collection<String> getLenses() {
            if (lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return lenses;
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String... lenses) {
            lenses(Arrays.asList(lenses));
            return this;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
        }

        public final String getNotes() {
            return notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkloadRequest build() {
            return new CreateWorkloadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
