/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.AccessDeniedException;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ConflictException;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.InternalServerException;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ResourceNotFoundException;
import software.amazon.awssdk.services.wellarchitected.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.wellarchitected.model.ThrottlingException;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.ValidationException;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedException;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable;
import software.amazon.awssdk.services.wellarchitected.transform.AssociateLensesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateMilestoneRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateWorkloadShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DeleteWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DeleteWorkloadShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DisassociateLensesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetAnswerRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensReviewReportRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensReviewRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensVersionDifferenceRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetMilestoneRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListAnswersRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensReviewImprovementsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensReviewsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListMilestonesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListNotificationsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListShareInvitationsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListWorkloadSharesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListWorkloadsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateAnswerRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateLensReviewRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateWorkloadShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpgradeLensReviewRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWellArchitectedClient
implements WellArchitectedClient {
    private static final Logger log = Logger.loggerFor(DefaultWellArchitectedClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWellArchitectedClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "wellarchitected";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateLensesResponse associateLenses(AssociateLensesRequest associateLensesRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateLensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, associateLensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateLenses");
            AssociateLensesResponse associateLensesResponse = (AssociateLensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateLenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateLensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateLensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateLensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$associateLenses$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMilestoneResponse createMilestone(CreateMilestoneRequest createMilestoneRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMilestoneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createMilestoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMilestone");
            CreateMilestoneResponse createMilestoneResponse = (CreateMilestoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMilestone").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMilestoneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMilestoneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMilestoneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createMilestone$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkloadResponse createWorkload(CreateWorkloadRequest createWorkloadRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkload");
            CreateWorkloadResponse createWorkloadResponse = (CreateWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createWorkload$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkloadShareResponse createWorkloadShare(CreateWorkloadShareRequest createWorkloadShareRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkloadShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createWorkloadShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkloadShare");
            CreateWorkloadShareResponse createWorkloadShareResponse = (CreateWorkloadShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkloadShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkloadShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkloadShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkloadShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createWorkloadShare$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkloadResponse deleteWorkload(DeleteWorkloadRequest deleteWorkloadRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkload");
            DeleteWorkloadResponse deleteWorkloadResponse = (DeleteWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$deleteWorkload$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkloadShareResponse deleteWorkloadShare(DeleteWorkloadShareRequest deleteWorkloadShareRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkloadShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkloadShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkloadShare");
            DeleteWorkloadShareResponse deleteWorkloadShareResponse = (DeleteWorkloadShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkloadShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkloadShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkloadShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkloadShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$deleteWorkloadShare$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateLensesResponse disassociateLenses(DisassociateLensesRequest disassociateLensesRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateLensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, disassociateLensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateLenses");
            DisassociateLensesResponse disassociateLensesResponse = (DisassociateLensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateLenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateLensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateLensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateLensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$disassociateLenses$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnswerResponse getAnswer(GetAnswerRequest getAnswerRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnswerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getAnswerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnswer");
            GetAnswerResponse getAnswerResponse = (GetAnswerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnswer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnswerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnswerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnswerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getAnswer$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensReviewResponse getLensReview(GetLensReviewRequest getLensReviewRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLensReview");
            GetLensReviewResponse getLensReviewResponse = (GetLensReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLensReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLensReview$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensReviewReportResponse getLensReviewReport(GetLensReviewReportRequest getLensReviewReportRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensReviewReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensReviewReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLensReviewReport");
            GetLensReviewReportResponse getLensReviewReportResponse = (GetLensReviewReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLensReviewReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensReviewReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensReviewReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensReviewReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLensReviewReport$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensVersionDifferenceResponse getLensVersionDifference(GetLensVersionDifferenceRequest getLensVersionDifferenceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensVersionDifferenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensVersionDifferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLensVersionDifference");
            GetLensVersionDifferenceResponse getLensVersionDifferenceResponse = (GetLensVersionDifferenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLensVersionDifference").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensVersionDifferenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensVersionDifferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensVersionDifferenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLensVersionDifference$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMilestoneResponse getMilestone(GetMilestoneRequest getMilestoneRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMilestoneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getMilestoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMilestone");
            GetMilestoneResponse getMilestoneResponse = (GetMilestoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMilestone").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMilestoneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMilestoneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMilestoneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getMilestone$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkloadResponse getWorkload(GetWorkloadRequest getWorkloadRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkload");
            GetWorkloadResponse getWorkloadResponse = (GetWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getWorkload$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnswersResponse listAnswers(ListAnswersRequest listAnswersRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnswersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listAnswersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnswers");
            ListAnswersResponse listAnswersResponse = (ListAnswersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnswers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnswersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnswersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnswersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listAnswers$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnswersIterable listAnswersPaginator(ListAnswersRequest listAnswersRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListAnswersIterable(this, this.applyPaginatorUserAgent(listAnswersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensReviewImprovementsResponse listLensReviewImprovements(ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensReviewImprovementsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensReviewImprovementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLensReviewImprovements");
            ListLensReviewImprovementsResponse listLensReviewImprovementsResponse = (ListLensReviewImprovementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLensReviewImprovements").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensReviewImprovementsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensReviewImprovementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensReviewImprovementsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLensReviewImprovements$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensReviewImprovementsIterable listLensReviewImprovementsPaginator(ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensReviewImprovementsIterable(this, this.applyPaginatorUserAgent(listLensReviewImprovementsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensReviewsResponse listLensReviews(ListLensReviewsRequest listLensReviewsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensReviewsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensReviewsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLensReviews");
            ListLensReviewsResponse listLensReviewsResponse = (ListLensReviewsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLensReviews").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensReviewsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensReviewsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensReviewsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLensReviews$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensReviewsIterable listLensReviewsPaginator(ListLensReviewsRequest listLensReviewsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensReviewsIterable(this, this.applyPaginatorUserAgent(listLensReviewsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensesResponse listLenses(ListLensesRequest listLensesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLenses");
            ListLensesResponse listLensesResponse = (ListLensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLenses$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensesIterable listLensesPaginator(ListLensesRequest listLensesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensesIterable(this, this.applyPaginatorUserAgent(listLensesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMilestonesResponse listMilestones(ListMilestonesRequest listMilestonesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMilestonesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listMilestonesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMilestones");
            ListMilestonesResponse listMilestonesResponse = (ListMilestonesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMilestones").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMilestonesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMilestonesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMilestonesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listMilestones$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMilestonesIterable listMilestonesPaginator(ListMilestonesRequest listMilestonesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListMilestonesIterable(this, this.applyPaginatorUserAgent(listMilestonesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotificationsResponse listNotifications(ListNotificationsRequest listNotificationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listNotificationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNotifications");
            ListNotificationsResponse listNotificationsResponse = (ListNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNotificationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNotificationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listNotifications$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNotificationsIterable listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListNotificationsIterable(this, this.applyPaginatorUserAgent(listNotificationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListShareInvitationsResponse listShareInvitations(ListShareInvitationsRequest listShareInvitationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListShareInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listShareInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListShareInvitations");
            ListShareInvitationsResponse listShareInvitationsResponse = (ListShareInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListShareInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listShareInvitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListShareInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listShareInvitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listShareInvitations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListShareInvitationsIterable listShareInvitationsPaginator(ListShareInvitationsRequest listShareInvitationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListShareInvitationsIterable(this, this.applyPaginatorUserAgent(listShareInvitationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkloadSharesResponse listWorkloadShares(ListWorkloadSharesRequest listWorkloadSharesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkloadSharesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listWorkloadSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkloadShares");
            ListWorkloadSharesResponse listWorkloadSharesResponse = (ListWorkloadSharesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkloadShares").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkloadSharesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkloadSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkloadSharesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listWorkloadShares$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkloadSharesIterable listWorkloadSharesPaginator(ListWorkloadSharesRequest listWorkloadSharesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListWorkloadSharesIterable(this, this.applyPaginatorUserAgent(listWorkloadSharesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkloadsResponse listWorkloads(ListWorkloadsRequest listWorkloadsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkloadsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listWorkloadsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkloads");
            ListWorkloadsResponse listWorkloadsResponse = (ListWorkloadsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkloads").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkloadsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkloadsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkloadsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listWorkloads$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkloadsIterable listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListWorkloadsIterable(this, this.applyPaginatorUserAgent(listWorkloadsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnswerResponse updateAnswer(UpdateAnswerRequest updateAnswerRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnswerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateAnswerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnswer");
            UpdateAnswerResponse updateAnswerResponse = (UpdateAnswerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnswer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAnswerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnswerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnswerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateAnswer$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLensReviewResponse updateLensReview(UpdateLensReviewRequest updateLensReviewRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLensReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateLensReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLensReview");
            UpdateLensReviewResponse updateLensReviewResponse = (UpdateLensReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLensReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLensReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLensReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLensReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateLensReview$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateShareInvitationResponse updateShareInvitation(UpdateShareInvitationRequest updateShareInvitationRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateShareInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateShareInvitation");
            UpdateShareInvitationResponse updateShareInvitationResponse = (UpdateShareInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateShareInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateShareInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateShareInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateShareInvitation$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkloadResponse updateWorkload(UpdateWorkloadRequest updateWorkloadRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkload");
            UpdateWorkloadResponse updateWorkloadResponse = (UpdateWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateWorkload$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkloadShareResponse updateWorkloadShare(UpdateWorkloadShareRequest updateWorkloadShareRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkloadShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateWorkloadShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkloadShare");
            UpdateWorkloadShareResponse updateWorkloadShareResponse = (UpdateWorkloadShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkloadShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkloadShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkloadShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkloadShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateWorkloadShare$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeLensReviewResponse upgradeLensReview(UpgradeLensReviewRequest upgradeLensReviewRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeLensReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, upgradeLensReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradeLensReview");
            UpgradeLensReviewResponse upgradeLensReviewResponse = (UpgradeLensReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeLensReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)upgradeLensReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpgradeLensReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return upgradeLensReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$upgradeLensReview$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WellArchitectedException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends WellArchitectedRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.58").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WellArchitectedRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$upgradeLensReview$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkloadShare$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkload$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateShareInvitation$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLensReview$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnswer$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkloads$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkloadShares$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listShareInvitations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNotifications$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMilestones$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLenses$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLensReviews$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLensReviewImprovements$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnswers$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkload$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMilestone$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLensVersionDifference$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLensReviewReport$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLensReview$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnswer$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateLenses$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkloadShare$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkload$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkloadShare$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkload$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMilestone$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateLenses$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

