/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadShareSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadShareSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadSharesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListWorkloadSharesResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListWorkloadSharesResponse.getter(ListWorkloadSharesResponse::workloadId)).setter(ListWorkloadSharesResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<List<WorkloadShareSummary>> WORKLOAD_SHARE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkloadShareSummaries").getter(ListWorkloadSharesResponse.getter(ListWorkloadSharesResponse::workloadShareSummaries)).setter(ListWorkloadSharesResponse.setter(Builder::workloadShareSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadShareSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadShareSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkloadSharesResponse.getter(ListWorkloadSharesResponse::nextToken)).setter(ListWorkloadSharesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_SHARE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String workloadId;
    private final List<WorkloadShareSummary> workloadShareSummaries;
    private final String nextToken;

    private ListWorkloadSharesResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.workloadShareSummaries = builder.workloadShareSummaries;
        this.nextToken = builder.nextToken;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public boolean hasWorkloadShareSummaries() {
        return this.workloadShareSummaries != null && !(this.workloadShareSummaries instanceof SdkAutoConstructList);
    }

    public List<WorkloadShareSummary> workloadShareSummaries() {
        return this.workloadShareSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadShareSummaries() ? this.workloadShareSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadSharesResponse)) {
            return false;
        }
        ListWorkloadSharesResponse other = (ListWorkloadSharesResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && this.hasWorkloadShareSummaries() == other.hasWorkloadShareSummaries() && Objects.equals(this.workloadShareSummaries(), other.workloadShareSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWorkloadSharesResponse").add("WorkloadId", (Object)this.workloadId()).add("WorkloadShareSummaries", this.hasWorkloadShareSummaries() ? this.workloadShareSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadShareSummaries": {
                return Optional.ofNullable(clazz.cast(this.workloadShareSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadSharesResponse, T> g) {
        return obj -> g.apply((ListWorkloadSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private List<WorkloadShareSummary> workloadShareSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadSharesResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.workloadShareSummaries(model.workloadShareSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Collection<WorkloadShareSummary.Builder> getWorkloadShareSummaries() {
            if (this.workloadShareSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workloadShareSummaries != null ? (Collection)this.workloadShareSummaries.stream().map(WorkloadShareSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workloadShareSummaries(Collection<WorkloadShareSummary> workloadShareSummaries) {
            this.workloadShareSummaries = WorkloadShareSummariesCopier.copy(workloadShareSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadShareSummaries(WorkloadShareSummary ... workloadShareSummaries) {
            this.workloadShareSummaries(Arrays.asList(workloadShareSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadShareSummaries(Consumer<WorkloadShareSummary.Builder> ... workloadShareSummaries) {
            this.workloadShareSummaries(Stream.of(workloadShareSummaries).map(c -> (WorkloadShareSummary)((WorkloadShareSummary.Builder)WorkloadShareSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkloadShareSummaries(Collection<WorkloadShareSummary.BuilderImpl> workloadShareSummaries) {
            this.workloadShareSummaries = WorkloadShareSummariesCopier.copyFromBuilder(workloadShareSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorkloadSharesResponse build() {
            return new ListWorkloadSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadSharesResponse> {
        public Builder workloadId(String var1);

        public Builder workloadShareSummaries(Collection<WorkloadShareSummary> var1);

        public Builder workloadShareSummaries(WorkloadShareSummary ... var1);

        public Builder workloadShareSummaries(Consumer<WorkloadShareSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

