/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensUpgradeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensUpgradeSummary> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(LensUpgradeSummary.getter(LensUpgradeSummary::workloadId)).setter(LensUpgradeSummary.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(LensUpgradeSummary.getter(LensUpgradeSummary::workloadName)).setter(LensUpgradeSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensUpgradeSummary.getter(LensUpgradeSummary::lensAlias)).setter(LensUpgradeSummary.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> CURRENT_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentLensVersion").getter(LensUpgradeSummary.getter(LensUpgradeSummary::currentLensVersion)).setter(LensUpgradeSummary.setter(Builder::currentLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentLensVersion").build()}).build();
    private static final SdkField<String> LATEST_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestLensVersion").getter(LensUpgradeSummary.getter(LensUpgradeSummary::latestLensVersion)).setter(LensUpgradeSummary.setter(Builder::latestLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestLensVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD, LENS_ALIAS_FIELD, CURRENT_LENS_VERSION_FIELD, LATEST_LENS_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workloadId;
    private final String workloadName;
    private final String lensAlias;
    private final String currentLensVersion;
    private final String latestLensVersion;

    private LensUpgradeSummary(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.lensAlias = builder.lensAlias;
        this.currentLensVersion = builder.currentLensVersion;
        this.latestLensVersion = builder.latestLensVersion;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public String workloadName() {
        return this.workloadName;
    }

    public String lensAlias() {
        return this.lensAlias;
    }

    public String currentLensVersion() {
        return this.currentLensVersion;
    }

    public String latestLensVersion() {
        return this.latestLensVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestLensVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensUpgradeSummary)) {
            return false;
        }
        LensUpgradeSummary other = (LensUpgradeSummary)obj;
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.currentLensVersion(), other.currentLensVersion()) && Objects.equals(this.latestLensVersion(), other.latestLensVersion());
    }

    public String toString() {
        return ToString.builder((String)"LensUpgradeSummary").add("WorkloadId", (Object)this.workloadId()).add("WorkloadName", (Object)this.workloadName()).add("LensAlias", (Object)this.lensAlias()).add("CurrentLensVersion", (Object)this.currentLensVersion()).add("LatestLensVersion", (Object)this.latestLensVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "CurrentLensVersion": {
                return Optional.ofNullable(clazz.cast(this.currentLensVersion()));
            }
            case "LatestLensVersion": {
                return Optional.ofNullable(clazz.cast(this.latestLensVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensUpgradeSummary, T> g) {
        return obj -> g.apply((LensUpgradeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workloadId;
        private String workloadName;
        private String lensAlias;
        private String currentLensVersion;
        private String latestLensVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LensUpgradeSummary model) {
            this.workloadId(model.workloadId);
            this.workloadName(model.workloadName);
            this.lensAlias(model.lensAlias);
            this.currentLensVersion(model.currentLensVersion);
            this.latestLensVersion(model.latestLensVersion);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getCurrentLensVersion() {
            return this.currentLensVersion;
        }

        @Override
        public final Builder currentLensVersion(String currentLensVersion) {
            this.currentLensVersion = currentLensVersion;
            return this;
        }

        public final void setCurrentLensVersion(String currentLensVersion) {
            this.currentLensVersion = currentLensVersion;
        }

        public final String getLatestLensVersion() {
            return this.latestLensVersion;
        }

        @Override
        public final Builder latestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
            return this;
        }

        public final void setLatestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
        }

        public LensUpgradeSummary build() {
            return new LensUpgradeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensUpgradeSummary> {
        public Builder workloadId(String var1);

        public Builder workloadName(String var1);

        public Builder lensAlias(String var1);

        public Builder currentLensVersion(String var1);

        public Builder latestLensVersion(String var1);
    }
}

