/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.Milestone;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMilestoneResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, GetMilestoneResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(GetMilestoneResponse.getter(GetMilestoneResponse::workloadId)).setter(GetMilestoneResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<Milestone> MILESTONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Milestone").getter(GetMilestoneResponse.getter(GetMilestoneResponse::milestone)).setter(GetMilestoneResponse.setter(Builder::milestone)).constructor(Milestone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Milestone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_FIELD));
    private final String workloadId;
    private final Milestone milestone;

    private GetMilestoneResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestone = builder.milestone;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public Milestone milestone() {
        return this.milestone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMilestoneResponse)) {
            return false;
        }
        GetMilestoneResponse other = (GetMilestoneResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.milestone(), other.milestone());
    }

    public String toString() {
        return ToString.builder((String)"GetMilestoneResponse").add("WorkloadId", (Object)this.workloadId()).add("Milestone", (Object)this.milestone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "Milestone": {
                return Optional.ofNullable(clazz.cast(this.milestone()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMilestoneResponse, T> g) {
        return obj -> g.apply((GetMilestoneResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private Milestone milestone;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMilestoneResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestone(model.milestone);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Milestone.Builder getMilestone() {
            return this.milestone != null ? this.milestone.toBuilder() : null;
        }

        @Override
        public final Builder milestone(Milestone milestone) {
            this.milestone = milestone;
            return this;
        }

        public final void setMilestone(Milestone.BuilderImpl milestone) {
            this.milestone = milestone != null ? milestone.build() : null;
        }

        @Override
        public GetMilestoneResponse build() {
            return new GetMilestoneResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMilestoneResponse> {
        public Builder workloadId(String var1);

        public Builder milestone(Milestone var1);

        default public Builder milestone(Consumer<Milestone.Builder> milestone) {
            return this.milestone((Milestone)((Milestone.Builder)Milestone.builder().applyMutation(milestone)).build());
        }
    }
}

