/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Choice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Choice> {
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChoiceId").getter(Choice.getter(Choice::choiceId)).setter(Choice.setter(Builder::choiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Choice.getter(Choice::title)).setter(Choice.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Choice.getter(Choice::description)).setter(Choice.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHOICE_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String choiceId;
    private final String title;
    private final String description;

    private Choice(BuilderImpl builder) {
        this.choiceId = builder.choiceId;
        this.title = builder.title;
        this.description = builder.description;
    }

    public String choiceId() {
        return this.choiceId;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Choice)) {
            return false;
        }
        Choice other = (Choice)obj;
        return Objects.equals(this.choiceId(), other.choiceId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"Choice").add("ChoiceId", (Object)this.choiceId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChoiceId": {
                return Optional.ofNullable(clazz.cast(this.choiceId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Choice, T> g) {
        return obj -> g.apply((Choice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String choiceId;
        private String title;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Choice model) {
            this.choiceId(model.choiceId);
            this.title(model.title);
            this.description(model.description);
        }

        public final String getChoiceId() {
            return this.choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public Choice build() {
            return new Choice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Choice> {
        public Builder choiceId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);
    }
}

