/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.DataProtection;
import software.amazon.awssdk.services.wafv2.model.DataProtectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProtectionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProtectionConfig> {
    private static final SdkField<List<DataProtection>> DATA_PROTECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataProtections").getter(DataProtectionConfig.getter(DataProtectionConfig::dataProtections)).setter(DataProtectionConfig.setter(Builder::dataProtections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProtections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProtection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROTECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProtectionConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DataProtection> dataProtections;

    private DataProtectionConfig(BuilderImpl builder) {
        this.dataProtections = builder.dataProtections;
    }

    public final boolean hasDataProtections() {
        return this.dataProtections != null && !(this.dataProtections instanceof SdkAutoConstructList);
    }

    public final List<DataProtection> dataProtections() {
        return this.dataProtections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataProtections() ? this.dataProtections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtectionConfig)) {
            return false;
        }
        DataProtectionConfig other = (DataProtectionConfig)obj;
        return this.hasDataProtections() == other.hasDataProtections() && Objects.equals(this.dataProtections(), other.dataProtections());
    }

    public final String toString() {
        return ToString.builder((String)"DataProtectionConfig").add("DataProtections", this.hasDataProtections() ? this.dataProtections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataProtections": {
                return Optional.ofNullable(clazz.cast(this.dataProtections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DataProtection>>> map = new HashMap<String, SdkField<List<DataProtection>>>();
        map.put("DataProtections", DATA_PROTECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProtectionConfig, T> g) {
        return obj -> g.apply((DataProtectionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataProtection> dataProtections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtectionConfig model) {
            this.dataProtections(model.dataProtections);
        }

        public final List<DataProtection.Builder> getDataProtections() {
            List<DataProtection.Builder> result = DataProtectionsCopier.copyToBuilder(this.dataProtections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataProtections(Collection<DataProtection.BuilderImpl> dataProtections) {
            this.dataProtections = DataProtectionsCopier.copyFromBuilder(dataProtections);
        }

        @Override
        public final Builder dataProtections(Collection<DataProtection> dataProtections) {
            this.dataProtections = DataProtectionsCopier.copy(dataProtections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataProtections(DataProtection ... dataProtections) {
            this.dataProtections(Arrays.asList(dataProtections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataProtections(Consumer<DataProtection.Builder> ... dataProtections) {
            this.dataProtections(Stream.of(dataProtections).map(c -> (DataProtection)((DataProtection.Builder)DataProtection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataProtectionConfig build() {
            return new DataProtectionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProtectionConfig> {
        public Builder dataProtections(Collection<DataProtection> var1);

        public Builder dataProtections(DataProtection ... var1);

        public Builder dataProtections(Consumer<DataProtection.Builder> ... var1);
    }
}

