/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation failed because the specified WAF feature isn't supported by the CloudFront pricing plan associated with
 * the web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WafFeatureNotIncludedInPricingPlanException extends Wafv2Exception implements
        ToCopyableBuilder<WafFeatureNotIncludedInPricingPlanException.Builder, WafFeatureNotIncludedInPricingPlanException> {
    private static final SdkField<List<DisallowedFeature>> DISALLOWED_FEATURES_FIELD = SdkField
            .<List<DisallowedFeature>> builder(MarshallingType.LIST)
            .memberName("DisallowedFeatures")
            .getter(getter(WafFeatureNotIncludedInPricingPlanException::disallowedFeatures))
            .setter(setter(Builder::disallowedFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisallowedFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DisallowedFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisallowedFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISALLOWED_FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DisallowedFeature> disallowedFeatures;

    private WafFeatureNotIncludedInPricingPlanException(BuilderImpl builder) {
        super(builder);
        this.disallowedFeatures = builder.disallowedFeatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisallowedFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasDisallowedFeatures() {
        return disallowedFeatures != null && !(disallowedFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the disallowed WAF features.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisallowedFeatures} method.
     * </p>
     * 
     * @return The names of the disallowed WAF features.
     */
    public List<DisallowedFeature> disallowedFeatures() {
        return disallowedFeatures;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisallowedFeatures", DISALLOWED_FEATURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WafFeatureNotIncludedInPricingPlanException, T> g) {
        return obj -> g.apply((WafFeatureNotIncludedInPricingPlanException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WafFeatureNotIncludedInPricingPlanException>,
            Wafv2Exception.Builder {
        /**
         * <p>
         * The names of the disallowed WAF features.
         * </p>
         * 
         * @param disallowedFeatures
         *        The names of the disallowed WAF features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowedFeatures(Collection<DisallowedFeature> disallowedFeatures);

        /**
         * <p>
         * The names of the disallowed WAF features.
         * </p>
         * 
         * @param disallowedFeatures
         *        The names of the disallowed WAF features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowedFeatures(DisallowedFeature... disallowedFeatures);

        /**
         * <p>
         * The names of the disallowed WAF features.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.DisallowedFeature.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.DisallowedFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.DisallowedFeature.Builder#build()} is called immediately
         * and its result is passed to {@link #disallowedFeatures(List<DisallowedFeature>)}.
         * 
         * @param disallowedFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.DisallowedFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disallowedFeatures(java.util.Collection<DisallowedFeature>)
         */
        Builder disallowedFeatures(Consumer<DisallowedFeature.Builder>... disallowedFeatures);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends Wafv2Exception.BuilderImpl implements Builder {
        private List<DisallowedFeature> disallowedFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WafFeatureNotIncludedInPricingPlanException model) {
            super(model);
            disallowedFeatures(model.disallowedFeatures);
        }

        public final List<DisallowedFeature.Builder> getDisallowedFeatures() {
            List<DisallowedFeature.Builder> result = DisallowedFeaturesCopier.copyToBuilder(this.disallowedFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisallowedFeatures(Collection<DisallowedFeature.BuilderImpl> disallowedFeatures) {
            this.disallowedFeatures = DisallowedFeaturesCopier.copyFromBuilder(disallowedFeatures);
        }

        @Override
        public final Builder disallowedFeatures(Collection<DisallowedFeature> disallowedFeatures) {
            this.disallowedFeatures = DisallowedFeaturesCopier.copy(disallowedFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disallowedFeatures(DisallowedFeature... disallowedFeatures) {
            disallowedFeatures(Arrays.asList(disallowedFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disallowedFeatures(Consumer<DisallowedFeature.Builder>... disallowedFeatures) {
            disallowedFeatures(Stream.of(disallowedFeatures).map(c -> DisallowedFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public WafFeatureNotIncludedInPricingPlanException build() {
            return new WafFeatureNotIncludedInPricingPlanException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
