/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use the request's JA3 fingerprint derived from the TLS Client Hello of an incoming request as an aggregate key. If
 * you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateLimitJA3Fingerprint implements SdkPojo, Serializable,
        ToCopyableBuilder<RateLimitJA3Fingerprint.Builder, RateLimitJA3Fingerprint> {
    private static final SdkField<String> FALLBACK_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallbackBehavior").getter(getter(RateLimitJA3Fingerprint::fallbackBehaviorAsString))
            .setter(setter(Builder::fallbackBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FALLBACK_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fallbackBehavior;

    private RateLimitJA3Fingerprint(BuilderImpl builder) {
        this.fallbackBehavior = builder.fallbackBehavior;
    }

    /**
     * <p>
     * The match status to assign to the web request if there is insufficient TSL Client Hello information to compute
     * the JA3 fingerprint.
     * </p>
     * <p>
     * You can specify the following fallback behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return The match status to assign to the web request if there is insufficient TSL Client Hello information to
     *         compute the JA3 fingerprint.</p>
     *         <p>
     *         You can specify the following fallback behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see FallbackBehavior
     */
    public final FallbackBehavior fallbackBehavior() {
        return FallbackBehavior.fromValue(fallbackBehavior);
    }

    /**
     * <p>
     * The match status to assign to the web request if there is insufficient TSL Client Hello information to compute
     * the JA3 fingerprint.
     * </p>
     * <p>
     * You can specify the following fallback behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return The match status to assign to the web request if there is insufficient TSL Client Hello information to
     *         compute the JA3 fingerprint.</p>
     *         <p>
     *         You can specify the following fallback behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see FallbackBehavior
     */
    public final String fallbackBehaviorAsString() {
        return fallbackBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fallbackBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateLimitJA3Fingerprint)) {
            return false;
        }
        RateLimitJA3Fingerprint other = (RateLimitJA3Fingerprint) obj;
        return Objects.equals(fallbackBehaviorAsString(), other.fallbackBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RateLimitJA3Fingerprint").add("FallbackBehavior", fallbackBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FallbackBehavior":
            return Optional.ofNullable(clazz.cast(fallbackBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FallbackBehavior", FALLBACK_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RateLimitJA3Fingerprint, T> g) {
        return obj -> g.apply((RateLimitJA3Fingerprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateLimitJA3Fingerprint> {
        /**
         * <p>
         * The match status to assign to the web request if there is insufficient TSL Client Hello information to
         * compute the JA3 fingerprint.
         * </p>
         * <p>
         * You can specify the following fallback behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fallbackBehavior
         *        The match status to assign to the web request if there is insufficient TSL Client Hello information to
         *        compute the JA3 fingerprint.</p>
         *        <p>
         *        You can specify the following fallback behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(String fallbackBehavior);

        /**
         * <p>
         * The match status to assign to the web request if there is insufficient TSL Client Hello information to
         * compute the JA3 fingerprint.
         * </p>
         * <p>
         * You can specify the following fallback behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fallbackBehavior
         *        The match status to assign to the web request if there is insufficient TSL Client Hello information to
         *        compute the JA3 fingerprint.</p>
         *        <p>
         *        You can specify the following fallback behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(FallbackBehavior fallbackBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String fallbackBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(RateLimitJA3Fingerprint model) {
            fallbackBehavior(model.fallbackBehavior);
        }

        public final String getFallbackBehavior() {
            return fallbackBehavior;
        }

        public final void setFallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
        }

        @Override
        public final Builder fallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
            return this;
        }

        @Override
        public final Builder fallbackBehavior(FallbackBehavior fallbackBehavior) {
            this.fallbackBehavior(fallbackBehavior == null ? null : fallbackBehavior.toString());
            return this;
        }

        @Override
        public RateLimitJA3Fingerprint build() {
            return new RateLimitJA3Fingerprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
