/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnSourceDDoSProtectionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OnSourceDDoSProtectionConfig.Builder, OnSourceDDoSProtectionConfig> {
    private static final SdkField<String> ALB_LOW_REPUTATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ALBLowReputationMode").getter(getter(OnSourceDDoSProtectionConfig::albLowReputationModeAsString))
            .setter(setter(Builder::albLowReputationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ALBLowReputationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ALB_LOW_REPUTATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String albLowReputationMode;

    private OnSourceDDoSProtectionConfig(BuilderImpl builder) {
        this.albLowReputationMode = builder.albLowReputationMode;
    }

    /**
     * <p>
     * The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     * <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an
     * Application Load Balancer. In the event that an Application Load Balancer experiences high-load conditions or
     * suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate limits traffic from
     * known low reputation sources without disrupting Application Load Balancer availability. <code>ALWAYS_ON</code>
     * protection provides constant, always-on monitoring of known low reputation sources for suspected DDoS attacks.
     * While this provides a higher level of protection, there may be potential impacts on legitimate traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #albLowReputationMode} will return {@link LowReputationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #albLowReputationModeAsString}.
     * </p>
     * 
     * @return The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     *         <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an
     *         Application Load Balancer. In the event that an Application Load Balancer experiences high-load
     *         conditions or suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate
     *         limits traffic from known low reputation sources without disrupting Application Load Balancer
     *         availability. <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low
     *         reputation sources for suspected DDoS attacks. While this provides a higher level of protection, there
     *         may be potential impacts on legitimate traffic.
     * @see LowReputationMode
     */
    public final LowReputationMode albLowReputationMode() {
        return LowReputationMode.fromValue(albLowReputationMode);
    }

    /**
     * <p>
     * The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     * <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an
     * Application Load Balancer. In the event that an Application Load Balancer experiences high-load conditions or
     * suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate limits traffic from
     * known low reputation sources without disrupting Application Load Balancer availability. <code>ALWAYS_ON</code>
     * protection provides constant, always-on monitoring of known low reputation sources for suspected DDoS attacks.
     * While this provides a higher level of protection, there may be potential impacts on legitimate traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #albLowReputationMode} will return {@link LowReputationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #albLowReputationModeAsString}.
     * </p>
     * 
     * @return The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     *         <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an
     *         Application Load Balancer. In the event that an Application Load Balancer experiences high-load
     *         conditions or suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate
     *         limits traffic from known low reputation sources without disrupting Application Load Balancer
     *         availability. <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low
     *         reputation sources for suspected DDoS attacks. While this provides a higher level of protection, there
     *         may be potential impacts on legitimate traffic.
     * @see LowReputationMode
     */
    public final String albLowReputationModeAsString() {
        return albLowReputationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(albLowReputationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnSourceDDoSProtectionConfig)) {
            return false;
        }
        OnSourceDDoSProtectionConfig other = (OnSourceDDoSProtectionConfig) obj;
        return Objects.equals(albLowReputationModeAsString(), other.albLowReputationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnSourceDDoSProtectionConfig").add("ALBLowReputationMode", albLowReputationModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ALBLowReputationMode":
            return Optional.ofNullable(clazz.cast(albLowReputationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ALBLowReputationMode", ALB_LOW_REPUTATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnSourceDDoSProtectionConfig, T> g) {
        return obj -> g.apply((OnSourceDDoSProtectionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnSourceDDoSProtectionConfig> {
        /**
         * <p>
         * The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         * <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an
         * Application Load Balancer. In the event that an Application Load Balancer experiences high-load conditions or
         * suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate limits traffic from
         * known low reputation sources without disrupting Application Load Balancer availability.
         * <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low reputation sources for
         * suspected DDoS attacks. While this provides a higher level of protection, there may be potential impacts on
         * legitimate traffic.
         * </p>
         * 
         * @param albLowReputationMode
         *        The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         *        <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with
         *        an Application Load Balancer. In the event that an Application Load Balancer experiences high-load
         *        conditions or suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate
         *        limits traffic from known low reputation sources without disrupting Application Load Balancer
         *        availability. <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low
         *        reputation sources for suspected DDoS attacks. While this provides a higher level of protection, there
         *        may be potential impacts on legitimate traffic.
         * @see LowReputationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LowReputationMode
         */
        Builder albLowReputationMode(String albLowReputationMode);

        /**
         * <p>
         * The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         * <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an
         * Application Load Balancer. In the event that an Application Load Balancer experiences high-load conditions or
         * suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate limits traffic from
         * known low reputation sources without disrupting Application Load Balancer availability.
         * <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low reputation sources for
         * suspected DDoS attacks. While this provides a higher level of protection, there may be potential impacts on
         * legitimate traffic.
         * </p>
         * 
         * @param albLowReputationMode
         *        The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         *        <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with
         *        an Application Load Balancer. In the event that an Application Load Balancer experiences high-load
         *        conditions or suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate
         *        limits traffic from known low reputation sources without disrupting Application Load Balancer
         *        availability. <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low
         *        reputation sources for suspected DDoS attacks. While this provides a higher level of protection, there
         *        may be potential impacts on legitimate traffic.
         * @see LowReputationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LowReputationMode
         */
        Builder albLowReputationMode(LowReputationMode albLowReputationMode);
    }

    static final class BuilderImpl implements Builder {
        private String albLowReputationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(OnSourceDDoSProtectionConfig model) {
            albLowReputationMode(model.albLowReputationMode);
        }

        public final String getAlbLowReputationMode() {
            return albLowReputationMode;
        }

        public final void setAlbLowReputationMode(String albLowReputationMode) {
            this.albLowReputationMode = albLowReputationMode;
        }

        @Override
        public final Builder albLowReputationMode(String albLowReputationMode) {
            this.albLowReputationMode = albLowReputationMode;
            return this;
        }

        @Override
        public final Builder albLowReputationMode(LowReputationMode albLowReputationMode) {
            this.albLowReputationMode(albLowReputationMode == null ? null : albLowReputationMode.toString());
            return this;
        }

        @Override
        public OnSourceDDoSProtectionConfig build() {
            return new OnSourceDDoSProtectionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
