/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDecryptedApiKeyResponse extends Wafv2Response implements
        ToCopyableBuilder<GetDecryptedApiKeyResponse.Builder, GetDecryptedApiKeyResponse> {
    private static final SdkField<List<String>> TOKEN_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TokenDomains")
            .getter(getter(GetDecryptedApiKeyResponse::tokenDomains))
            .setter(setter(Builder::tokenDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(GetDecryptedApiKeyResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_DOMAINS_FIELD,
            CREATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> tokenDomains;

    private final Instant creationTimestamp;

    private GetDecryptedApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.tokenDomains = builder.tokenDomains;
        this.creationTimestamp = builder.creationTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTokenDomains() {
        return tokenDomains != null && !(tokenDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The token domains that are defined in this API key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenDomains} method.
     * </p>
     * 
     * @return The token domains that are defined in this API key.
     */
    public final List<String> tokenDomains() {
        return tokenDomains;
    }

    /**
     * <p>
     * The date and time that the key was created.
     * </p>
     * 
     * @return The date and time that the key was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenDomains() ? tokenDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDecryptedApiKeyResponse)) {
            return false;
        }
        GetDecryptedApiKeyResponse other = (GetDecryptedApiKeyResponse) obj;
        return hasTokenDomains() == other.hasTokenDomains() && Objects.equals(tokenDomains(), other.tokenDomains())
                && Objects.equals(creationTimestamp(), other.creationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDecryptedApiKeyResponse").add("TokenDomains", hasTokenDomains() ? tokenDomains() : null)
                .add("CreationTimestamp", creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TokenDomains":
            return Optional.ofNullable(clazz.cast(tokenDomains()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TokenDomains", TOKEN_DOMAINS_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDecryptedApiKeyResponse, T> g) {
        return obj -> g.apply((GetDecryptedApiKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetDecryptedApiKeyResponse> {
        /**
         * <p>
         * The token domains that are defined in this API key.
         * </p>
         * 
         * @param tokenDomains
         *        The token domains that are defined in this API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenDomains(Collection<String> tokenDomains);

        /**
         * <p>
         * The token domains that are defined in this API key.
         * </p>
         * 
         * @param tokenDomains
         *        The token domains that are defined in this API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenDomains(String... tokenDomains);

        /**
         * <p>
         * The date and time that the key was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The date and time that the key was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private List<String> tokenDomains = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDecryptedApiKeyResponse model) {
            super(model);
            tokenDomains(model.tokenDomains);
            creationTimestamp(model.creationTimestamp);
        }

        public final Collection<String> getTokenDomains() {
            if (tokenDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return tokenDomains;
        }

        public final void setTokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
        }

        @Override
        public final Builder tokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenDomains(String... tokenDomains) {
            tokenDomains(Arrays.asList(tokenDomains));
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public GetDecryptedApiKeyResponse build() {
            return new GetDecryptedApiKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
