/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inspect the body of the web request. The body immediately follows the request headers.
 * </p>
 * <p>
 * This is used to indicate the web request component to inspect, in the <a>FieldToMatch</a> specification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Body implements SdkPojo, Serializable, ToCopyableBuilder<Body.Builder, Body> {
    private static final SdkField<String> OVERSIZE_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OversizeHandling").getter(getter(Body::oversizeHandlingAsString))
            .setter(setter(Builder::oversizeHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OversizeHandling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERSIZE_HANDLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String oversizeHandling;

    private Body(BuilderImpl builder) {
        this.oversizeHandling = builder.oversizeHandling;
    }

    /**
     * <p>
     * What WAF should do if the body is larger than WAF can inspect.
     * </p>
     * <p>
     * WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the
     * resource type. When a web request body is larger than the limit, the underlying host service only forwards the
     * contents that are within the limit to WAF for inspection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     * </p>
     * </li>
     * <li>
     * <p>
     * For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384
     * bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code>, for
     * additional processing fees.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amplify, use the CloudFront limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The options for oversize handling are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and
     * web ACL action settings, so that you block any request whose body is over the limit.
     * </p>
     * <p>
     * Default: <code>CONTINUE</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oversizeHandling}
     * will return {@link OversizeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oversizeHandlingAsString}.
     * </p>
     * 
     * @return What WAF should do if the body is larger than WAF can inspect. </p>
     *         <p>
     *         WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit
     *         for the resource type. When a web request body is larger than the limit, the underlying host service only
     *         forwards the contents that are within the limit to WAF for inspection.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB
     *         (16,384 bytes), and you can increase the limit for each resource type in the web ACL
     *         <code>AssociationConfig</code>, for additional processing fees.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Amplify, use the CloudFront limit.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The options for oversize handling are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection
     *         criteria.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your
     *         rule and web ACL action settings, so that you block any request whose body is over the limit.
     *         </p>
     *         <p>
     *         Default: <code>CONTINUE</code>
     * @see OversizeHandling
     */
    public final OversizeHandling oversizeHandling() {
        return OversizeHandling.fromValue(oversizeHandling);
    }

    /**
     * <p>
     * What WAF should do if the body is larger than WAF can inspect.
     * </p>
     * <p>
     * WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the
     * resource type. When a web request body is larger than the limit, the underlying host service only forwards the
     * contents that are within the limit to WAF for inspection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     * </p>
     * </li>
     * <li>
     * <p>
     * For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384
     * bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code>, for
     * additional processing fees.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amplify, use the CloudFront limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The options for oversize handling are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and
     * web ACL action settings, so that you block any request whose body is over the limit.
     * </p>
     * <p>
     * Default: <code>CONTINUE</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oversizeHandling}
     * will return {@link OversizeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oversizeHandlingAsString}.
     * </p>
     * 
     * @return What WAF should do if the body is larger than WAF can inspect. </p>
     *         <p>
     *         WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit
     *         for the resource type. When a web request body is larger than the limit, the underlying host service only
     *         forwards the contents that are within the limit to WAF for inspection.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB
     *         (16,384 bytes), and you can increase the limit for each resource type in the web ACL
     *         <code>AssociationConfig</code>, for additional processing fees.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Amplify, use the CloudFront limit.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The options for oversize handling are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection
     *         criteria.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your
     *         rule and web ACL action settings, so that you block any request whose body is over the limit.
     *         </p>
     *         <p>
     *         Default: <code>CONTINUE</code>
     * @see OversizeHandling
     */
    public final String oversizeHandlingAsString() {
        return oversizeHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oversizeHandlingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Body)) {
            return false;
        }
        Body other = (Body) obj;
        return Objects.equals(oversizeHandlingAsString(), other.oversizeHandlingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Body").add("OversizeHandling", oversizeHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OversizeHandling":
            return Optional.ofNullable(clazz.cast(oversizeHandlingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OversizeHandling", OVERSIZE_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Body, T> g) {
        return obj -> g.apply((Body) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Body> {
        /**
         * <p>
         * What WAF should do if the body is larger than WAF can inspect.
         * </p>
         * <p>
         * WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for
         * the resource type. When a web request body is larger than the limit, the underlying host service only
         * forwards the contents that are within the limit to WAF for inspection.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         * </p>
         * </li>
         * <li>
         * <p>
         * For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB
         * (16,384 bytes), and you can increase the limit for each resource type in the web ACL
         * <code>AssociationConfig</code>, for additional processing fees.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Amplify, use the CloudFront limit.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The options for oversize handling are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection
         * criteria.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule
         * and web ACL action settings, so that you block any request whose body is over the limit.
         * </p>
         * <p>
         * Default: <code>CONTINUE</code>
         * </p>
         * 
         * @param oversizeHandling
         *        What WAF should do if the body is larger than WAF can inspect. </p>
         *        <p>
         *        WAF does not support inspecting the entire contents of the web request body if the body exceeds the
         *        limit for the resource type. When a web request body is larger than the limit, the underlying host
         *        service only forwards the contents that are within the limit to WAF for inspection.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16
         *        KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL
         *        <code>AssociationConfig</code>, for additional processing fees.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Amplify, use the CloudFront limit.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The options for oversize handling are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection
         *        criteria.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with
         *        your rule and web ACL action settings, so that you block any request whose body is over the limit.
         *        </p>
         *        <p>
         *        Default: <code>CONTINUE</code>
         * @see OversizeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OversizeHandling
         */
        Builder oversizeHandling(String oversizeHandling);

        /**
         * <p>
         * What WAF should do if the body is larger than WAF can inspect.
         * </p>
         * <p>
         * WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for
         * the resource type. When a web request body is larger than the limit, the underlying host service only
         * forwards the contents that are within the limit to WAF for inspection.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         * </p>
         * </li>
         * <li>
         * <p>
         * For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB
         * (16,384 bytes), and you can increase the limit for each resource type in the web ACL
         * <code>AssociationConfig</code>, for additional processing fees.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Amplify, use the CloudFront limit.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The options for oversize handling are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection
         * criteria.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule
         * and web ACL action settings, so that you block any request whose body is over the limit.
         * </p>
         * <p>
         * Default: <code>CONTINUE</code>
         * </p>
         * 
         * @param oversizeHandling
         *        What WAF should do if the body is larger than WAF can inspect. </p>
         *        <p>
         *        WAF does not support inspecting the entire contents of the web request body if the body exceeds the
         *        limit for the resource type. When a web request body is larger than the limit, the underlying host
         *        service only forwards the contents that are within the limit to WAF for inspection.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Application Load Balancer and AppSync, the limit is fixed at 8 KB (8,192 bytes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16
         *        KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL
         *        <code>AssociationConfig</code>, for additional processing fees.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Amplify, use the CloudFront limit.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The options for oversize handling are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection
         *        criteria.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action
         *        to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with
         *        your rule and web ACL action settings, so that you block any request whose body is over the limit.
         *        </p>
         *        <p>
         *        Default: <code>CONTINUE</code>
         * @see OversizeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OversizeHandling
         */
        Builder oversizeHandling(OversizeHandling oversizeHandling);
    }

    static final class BuilderImpl implements Builder {
        private String oversizeHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(Body model) {
            oversizeHandling(model.oversizeHandling);
        }

        public final String getOversizeHandling() {
            return oversizeHandling;
        }

        public final void setOversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
        }

        @Override
        public final Builder oversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
            return this;
        }

        @Override
        public final Builder oversizeHandling(OversizeHandling oversizeHandling) {
            this.oversizeHandling(oversizeHandling == null ? null : oversizeHandling.toString());
            return this;
        }

        @Override
        public Body build() {
            return new Body(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
