/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.wafv2.Wafv2AsyncClient;
import software.amazon.awssdk.services.wafv2.Wafv2ServiceClientConfiguration;
import software.amazon.awssdk.services.wafv2.internal.Wafv2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse;
import software.amazon.awssdk.services.wafv2.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeAllManagedProductsResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlRequest;
import software.amazon.awssdk.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse;
import software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest;
import software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyResponse;
import software.amazon.awssdk.services.wafv2.model.GetIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetManagedRuleSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest;
import software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListApiKeysRequest;
import software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse;
import software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest;
import software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest;
import software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.TagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.TagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.WafAssociatedItemException;
import software.amazon.awssdk.services.wafv2.model.WafConfigurationWarningException;
import software.amazon.awssdk.services.wafv2.model.WafDuplicateItemException;
import software.amazon.awssdk.services.wafv2.model.WafExpiredManagedRuleGroupVersionException;
import software.amazon.awssdk.services.wafv2.model.WafInternalErrorException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidOperationException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidParameterException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidPermissionPolicyException;
import software.amazon.awssdk.services.wafv2.model.WafInvalidResourceException;
import software.amazon.awssdk.services.wafv2.model.WafLimitsExceededException;
import software.amazon.awssdk.services.wafv2.model.WafLogDestinationPermissionIssueException;
import software.amazon.awssdk.services.wafv2.model.WafNonexistentItemException;
import software.amazon.awssdk.services.wafv2.model.WafOptimisticLockException;
import software.amazon.awssdk.services.wafv2.model.WafServiceLinkedRoleErrorException;
import software.amazon.awssdk.services.wafv2.model.WafSubscriptionNotFoundException;
import software.amazon.awssdk.services.wafv2.model.WafTagOperationException;
import software.amazon.awssdk.services.wafv2.model.WafTagOperationInternalErrorException;
import software.amazon.awssdk.services.wafv2.model.WafUnavailableEntityException;
import software.amazon.awssdk.services.wafv2.model.WafUnsupportedAggregateKeyTypeException;
import software.amazon.awssdk.services.wafv2.model.Wafv2Exception;
import software.amazon.awssdk.services.wafv2.transform.AssociateWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CheckCapacityRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.CreateWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteFirewallManagerRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeletePermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DeleteWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DescribeAllManagedProductsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DescribeManagedProductsByVendorRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DescribeManagedRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.DisassociateWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GenerateMobileSdkReleaseUrlRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetDecryptedApiKeyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetManagedRuleSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetMobileSdkReleaseRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetPermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetRateBasedStatementManagedKeysRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetSampledRequestsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetWebAclForResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.GetWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListAvailableManagedRuleGroupVersionsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListAvailableManagedRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListLoggingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListManagedRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListMobileSdkReleasesRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListRegexPatternSetsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListResourcesForWebAclRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.ListWebAcLsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.PutLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.PutManagedRuleSetVersionsRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.PutPermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateManagedRuleSetVersionExpiryDateRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.wafv2.transform.UpdateWebAclRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultWafv2AsyncClient
implements Wafv2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWafv2AsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWafv2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"WAFV2#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateWebAclResponse> associateWebACL(AssociateWebAclRequest associateWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, associateWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$associateWebACL$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$associateWebACL$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CheckCapacityResponse> checkCapacity(CheckCapacityRequest checkCapacityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)checkCapacityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, checkCapacityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckCapacity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckCapacityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckCapacity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CheckCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)checkCapacityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$checkCapacity$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$checkCapacity$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApiKeyResponse> createAPIKey(CreateApiKeyRequest createApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, createApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAPIKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAPIKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApiKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$createAPIKey$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$createAPIKey$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateIpSetResponse> createIPSet(CreateIpSetRequest createIpSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, createIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIpSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIPSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createIpSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$createIPSet$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$createIPSet$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRegexPatternSetResponse> createRegexPatternSet(CreateRegexPatternSetRequest createRegexPatternSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRegexPatternSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, createRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRegexPatternSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRegexPatternSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRegexPatternSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRegexPatternSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$createRegexPatternSet$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$createRegexPatternSet$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRuleGroupResponse> createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRuleGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, createRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRuleGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRuleGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$createRuleGroup$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$createRuleGroup$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWebAclResponse> createWebACL(CreateWebAclRequest createWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, createWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$createWebACL$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$createWebACL$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApiKeyResponse> deleteAPIKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAPIKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAPIKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApiKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteAPIKey$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteAPIKey$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFirewallManagerRuleGroupsResponse> deleteFirewallManagerRuleGroups(DeleteFirewallManagerRuleGroupsRequest deleteFirewallManagerRuleGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFirewallManagerRuleGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteFirewallManagerRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFirewallManagerRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFirewallManagerRuleGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFirewallManagerRuleGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFirewallManagerRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFirewallManagerRuleGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteFirewallManagerRuleGroups$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteFirewallManagerRuleGroups$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIpSetResponse> deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIpSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIPSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIpSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteIPSet$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteIPSet$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLoggingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoggingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoggingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoggingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteLoggingConfiguration$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteLoggingConfiguration$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePermissionPolicyResponse> deletePermissionPolicy(DeletePermissionPolicyRequest deletePermissionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deletePermissionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermissionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermissionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePermissionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePermissionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deletePermissionPolicy$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deletePermissionPolicy$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRegexPatternSetResponse> deleteRegexPatternSet(DeleteRegexPatternSetRequest deleteRegexPatternSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRegexPatternSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRegexPatternSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRegexPatternSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRegexPatternSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRegexPatternSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteRegexPatternSet$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteRegexPatternSet$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRuleGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRuleGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRuleGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteRuleGroup$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteRuleGroup$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWebAclResponse> deleteWebACL(DeleteWebAclRequest deleteWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$deleteWebACL$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$deleteWebACL$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAllManagedProductsResponse> describeAllManagedProducts(DescribeAllManagedProductsRequest describeAllManagedProductsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAllManagedProductsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, describeAllManagedProductsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAllManagedProducts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAllManagedProductsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAllManagedProducts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAllManagedProductsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAllManagedProductsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$describeAllManagedProducts$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$describeAllManagedProducts$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeManagedProductsByVendorResponse> describeManagedProductsByVendor(DescribeManagedProductsByVendorRequest describeManagedProductsByVendorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeManagedProductsByVendorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, describeManagedProductsByVendorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeManagedProductsByVendor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeManagedProductsByVendorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeManagedProductsByVendor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeManagedProductsByVendorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeManagedProductsByVendorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$describeManagedProductsByVendor$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$describeManagedProductsByVendor$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeManagedRuleGroupResponse> describeManagedRuleGroup(DescribeManagedRuleGroupRequest describeManagedRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeManagedRuleGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, describeManagedRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeManagedRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeManagedRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeManagedRuleGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeManagedRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeManagedRuleGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$describeManagedRuleGroup$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$describeManagedRuleGroup$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateWebAclResponse> disassociateWebACL(DisassociateWebAclRequest disassociateWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, disassociateWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$disassociateWebACL$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$disassociateWebACL$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateMobileSdkReleaseUrlResponse> generateMobileSdkReleaseUrl(GenerateMobileSdkReleaseUrlRequest generateMobileSdkReleaseUrlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateMobileSdkReleaseUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, generateMobileSdkReleaseUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateMobileSdkReleaseUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateMobileSdkReleaseUrlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateMobileSdkReleaseUrl").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateMobileSdkReleaseUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateMobileSdkReleaseUrlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$generateMobileSdkReleaseUrl$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$generateMobileSdkReleaseUrl$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDecryptedApiKeyResponse> getDecryptedAPIKey(GetDecryptedApiKeyRequest getDecryptedApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDecryptedApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getDecryptedApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDecryptedAPIKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDecryptedApiKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDecryptedAPIKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDecryptedApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDecryptedApiKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getDecryptedAPIKey$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getDecryptedAPIKey$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIpSetResponse> getIPSet(GetIpSetRequest getIpSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIpSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIPSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getIpSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getIPSet$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getIPSet$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoggingConfigurationResponse> getLoggingConfiguration(GetLoggingConfigurationRequest getLoggingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLoggingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoggingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoggingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoggingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getLoggingConfiguration$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getLoggingConfiguration$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetManagedRuleSetResponse> getManagedRuleSet(GetManagedRuleSetRequest getManagedRuleSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getManagedRuleSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getManagedRuleSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetManagedRuleSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetManagedRuleSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetManagedRuleSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetManagedRuleSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getManagedRuleSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getManagedRuleSet$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getManagedRuleSet$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMobileSdkReleaseResponse> getMobileSdkRelease(GetMobileSdkReleaseRequest getMobileSdkReleaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMobileSdkReleaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getMobileSdkReleaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMobileSdkRelease");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMobileSdkReleaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMobileSdkRelease").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetMobileSdkReleaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMobileSdkReleaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getMobileSdkRelease$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getMobileSdkRelease$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPermissionPolicyResponse> getPermissionPolicy(GetPermissionPolicyRequest getPermissionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPermissionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getPermissionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPermissionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPermissionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPermissionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPermissionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPermissionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getPermissionPolicy$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getPermissionPolicy$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRateBasedStatementManagedKeysResponse> getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest getRateBasedStatementManagedKeysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRateBasedStatementManagedKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getRateBasedStatementManagedKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRateBasedStatementManagedKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRateBasedStatementManagedKeysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRateBasedStatementManagedKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRateBasedStatementManagedKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRateBasedStatementManagedKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getRateBasedStatementManagedKeys$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getRateBasedStatementManagedKeys$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRegexPatternSetResponse> getRegexPatternSet(GetRegexPatternSetRequest getRegexPatternSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRegexPatternSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegexPatternSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegexPatternSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegexPatternSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRegexPatternSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getRegexPatternSet$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getRegexPatternSet$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRuleGroupResponse> getRuleGroup(GetRuleGroupRequest getRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRuleGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRuleGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRuleGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getRuleGroup$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getRuleGroup$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSampledRequestsResponse> getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSampledRequestsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getSampledRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSampledRequests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSampledRequestsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSampledRequests").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSampledRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSampledRequestsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getSampledRequests$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getSampledRequests$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWebAclResponse> getWebACL(GetWebAclRequest getWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getWebACL$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getWebACL$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWebAclForResourceResponse> getWebACLForResource(GetWebAclForResourceRequest getWebAclForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWebAclForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, getWebAclForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWebACLForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWebAclForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWebACLForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWebAclForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWebAclForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$getWebACLForResource$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$getWebACLForResource$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApiKeysResponse> listAPIKeys(ListApiKeysRequest listApiKeysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApiKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listApiKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAPIKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApiKeysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAPIKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListApiKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApiKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listAPIKeys$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listAPIKeys$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAvailableManagedRuleGroupVersionsResponse> listAvailableManagedRuleGroupVersions(ListAvailableManagedRuleGroupVersionsRequest listAvailableManagedRuleGroupVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAvailableManagedRuleGroupVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listAvailableManagedRuleGroupVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAvailableManagedRuleGroupVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAvailableManagedRuleGroupVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableManagedRuleGroupVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAvailableManagedRuleGroupVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAvailableManagedRuleGroupVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listAvailableManagedRuleGroupVersions$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listAvailableManagedRuleGroupVersions$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAvailableManagedRuleGroupsResponse> listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest listAvailableManagedRuleGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAvailableManagedRuleGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listAvailableManagedRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAvailableManagedRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAvailableManagedRuleGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableManagedRuleGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAvailableManagedRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAvailableManagedRuleGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listAvailableManagedRuleGroups$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listAvailableManagedRuleGroups$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIpSetsResponse> listIPSets(ListIpSetsRequest listIpSetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIpSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listIpSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIPSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIpSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIPSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListIpSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIpSetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listIPSets$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listIPSets$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLoggingConfigurationsResponse> listLoggingConfigurations(ListLoggingConfigurationsRequest listLoggingConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLoggingConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listLoggingConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLoggingConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLoggingConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLoggingConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLoggingConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLoggingConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listLoggingConfigurations$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listLoggingConfigurations$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListManagedRuleSetsResponse> listManagedRuleSets(ListManagedRuleSetsRequest listManagedRuleSetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listManagedRuleSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listManagedRuleSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedRuleSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedRuleSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedRuleSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListManagedRuleSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listManagedRuleSetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listManagedRuleSets$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listManagedRuleSets$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMobileSdkReleasesResponse> listMobileSdkReleases(ListMobileSdkReleasesRequest listMobileSdkReleasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMobileSdkReleasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listMobileSdkReleasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMobileSdkReleases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMobileSdkReleasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMobileSdkReleases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListMobileSdkReleasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMobileSdkReleasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listMobileSdkReleases$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listMobileSdkReleases$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRegexPatternSetsResponse> listRegexPatternSets(ListRegexPatternSetsRequest listRegexPatternSetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRegexPatternSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listRegexPatternSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegexPatternSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRegexPatternSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegexPatternSets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRegexPatternSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRegexPatternSetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listRegexPatternSets$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listRegexPatternSets$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourcesForWebAclResponse> listResourcesForWebACL(ListResourcesForWebAclRequest listResourcesForWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourcesForWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listResourcesForWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourcesForWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesForWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourcesForWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourcesForWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourcesForWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listResourcesForWebACL$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listResourcesForWebACL$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRuleGroupsResponse> listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRuleGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRuleGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listRuleGroups$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listRuleGroups$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listTagsForResource$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listTagsForResource$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWebAcLsResponse> listWebACLs(ListWebAcLsRequest listWebAcLsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWebAcLsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, listWebAcLsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebACLs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebAcLsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebACLs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWebAcLsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWebAcLsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$listWebACLs$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$listWebACLs$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutLoggingConfigurationResponse> putLoggingConfiguration(PutLoggingConfigurationRequest putLoggingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLoggingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, putLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLoggingConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLoggingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putLoggingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$putLoggingConfiguration$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$putLoggingConfiguration$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutManagedRuleSetVersionsResponse> putManagedRuleSetVersions(PutManagedRuleSetVersionsRequest putManagedRuleSetVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putManagedRuleSetVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, putManagedRuleSetVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutManagedRuleSetVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutManagedRuleSetVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutManagedRuleSetVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutManagedRuleSetVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putManagedRuleSetVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$putManagedRuleSetVersions$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$putManagedRuleSetVersions$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutPermissionPolicyResponse> putPermissionPolicy(PutPermissionPolicyRequest putPermissionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPermissionPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, putPermissionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPermissionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermissionPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutPermissionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putPermissionPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$putPermissionPolicy$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$putPermissionPolicy$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$tagResource$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$tagResource$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$untagResource$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$untagResource$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateIpSetResponse> updateIPSet(UpdateIpSetRequest updateIpSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateIpSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, updateIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIPSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIpSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIPSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateIpSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$updateIPSet$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$updateIPSet$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateManagedRuleSetVersionExpiryDateResponse> updateManagedRuleSetVersionExpiryDate(UpdateManagedRuleSetVersionExpiryDateRequest updateManagedRuleSetVersionExpiryDateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateManagedRuleSetVersionExpiryDateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, updateManagedRuleSetVersionExpiryDateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateManagedRuleSetVersionExpiryDate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateManagedRuleSetVersionExpiryDateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateManagedRuleSetVersionExpiryDate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateManagedRuleSetVersionExpiryDateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateManagedRuleSetVersionExpiryDateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$updateManagedRuleSetVersionExpiryDate$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$updateManagedRuleSetVersionExpiryDate$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRegexPatternSetResponse> updateRegexPatternSet(UpdateRegexPatternSetRequest updateRegexPatternSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRegexPatternSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, updateRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRegexPatternSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRegexPatternSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRegexPatternSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRegexPatternSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$updateRegexPatternSet$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$updateRegexPatternSet$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRuleGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, updateRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRuleGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuleGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRuleGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$updateRuleGroup$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$updateRuleGroup$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateWebAclResponse> updateWebACL(UpdateWebAclRequest updateWebAclRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateWebAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWafv2AsyncClient.resolveMetricPublishers(clientConfiguration, updateWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAFV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWebACL");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWebAclResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "WAFUnavailableEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnavailableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnavailableEntityException::builder).build());
                    }
                    case "WAFServiceLinkedRoleErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).build());
                    }
                    case "WAFOptimisticLockException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFOptimisticLockException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafOptimisticLockException::builder).build());
                    }
                    case "WAFSubscriptionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).build());
                    }
                    case "WAFConfigurationWarningException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFConfigurationWarningException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafConfigurationWarningException::builder).build());
                    }
                    case "WAFAssociatedItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFAssociatedItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafAssociatedItemException::builder).build());
                    }
                    case "WAFLimitsExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLimitsExceededException::builder).build());
                    }
                    case "WAFInvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidParameterException::builder).build());
                    }
                    case "WAFDuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFDuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafDuplicateItemException::builder).build());
                    }
                    case "WAFNonexistentItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafNonexistentItemException::builder).build());
                    }
                    case "WAFUnsupportedAggregateKeyTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFUnsupportedAggregateKeyTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafUnsupportedAggregateKeyTypeException::builder).build());
                    }
                    case "WAFInvalidPermissionPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).build());
                    }
                    case "WAFLogDestinationPermissionIssueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFLogDestinationPermissionIssueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafLogDestinationPermissionIssueException::builder).build());
                    }
                    case "WAFTagOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafTagOperationException::builder).build());
                    }
                    case "WAFTagOperationInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).build());
                    }
                    case "WAFInvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidOperationException::builder).build());
                    }
                    case "WAFInternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(WafInternalErrorException::builder).build());
                    }
                    case "WAFExpiredManagedRuleGroupVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFExpiredManagedRuleGroupVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafExpiredManagedRuleGroupVersionException::builder).build());
                    }
                    case "WAFInvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WAFInvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WafInvalidResourceException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWebACL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateWebAclRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWafv2AsyncClient.lambda$updateWebACL$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWafv2AsyncClient.lambda$updateWebACL$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final Wafv2ServiceClientConfiguration serviceClientConfiguration() {
        return new Wafv2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "wafv2";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Wafv2Exception::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        Wafv2ServiceClientConfigurationBuilder serviceConfigBuilder = new Wafv2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWebACL$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWebACL$214(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRuleGroup$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRuleGroup$210(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRegexPatternSet$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRegexPatternSet$206(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRegexPatternSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateManagedRuleSetVersionExpiryDate$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateManagedRuleSetVersionExpiryDate$202(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateManagedRuleSetVersionExpiryDateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateIPSet$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIPSet$198(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateIpSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$194(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$190(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putPermissionPolicy$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPermissionPolicy$186(List metricPublishers, MetricCollector apiCallMetricCollector, PutPermissionPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putManagedRuleSetVersions$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putManagedRuleSetVersions$182(List metricPublishers, MetricCollector apiCallMetricCollector, PutManagedRuleSetVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putLoggingConfiguration$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLoggingConfiguration$178(List metricPublishers, MetricCollector apiCallMetricCollector, PutLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWebACLs$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWebACLs$174(List metricPublishers, MetricCollector apiCallMetricCollector, ListWebAcLsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$170(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRuleGroups$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleGroups$166(List metricPublishers, MetricCollector apiCallMetricCollector, ListRuleGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResourcesForWebACL$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourcesForWebACL$162(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourcesForWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRegexPatternSets$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegexPatternSets$158(List metricPublishers, MetricCollector apiCallMetricCollector, ListRegexPatternSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMobileSdkReleases$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMobileSdkReleases$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListMobileSdkReleasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listManagedRuleSets$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedRuleSets$150(List metricPublishers, MetricCollector apiCallMetricCollector, ListManagedRuleSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLoggingConfigurations$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLoggingConfigurations$146(List metricPublishers, MetricCollector apiCallMetricCollector, ListLoggingConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIPSets$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIPSets$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListIpSetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAvailableManagedRuleGroups$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAvailableManagedRuleGroups$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListAvailableManagedRuleGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAvailableManagedRuleGroupVersions$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAvailableManagedRuleGroupVersions$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListAvailableManagedRuleGroupVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAPIKeys$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAPIKeys$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListApiKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWebACLForResource$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWebACLForResource$126(List metricPublishers, MetricCollector apiCallMetricCollector, GetWebAclForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWebACL$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWebACL$122(List metricPublishers, MetricCollector apiCallMetricCollector, GetWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSampledRequests$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSampledRequests$118(List metricPublishers, MetricCollector apiCallMetricCollector, GetSampledRequestsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRuleGroup$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRuleGroup$114(List metricPublishers, MetricCollector apiCallMetricCollector, GetRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRegexPatternSet$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegexPatternSet$110(List metricPublishers, MetricCollector apiCallMetricCollector, GetRegexPatternSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRateBasedStatementManagedKeys$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRateBasedStatementManagedKeys$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetRateBasedStatementManagedKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPermissionPolicy$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPermissionPolicy$102(List metricPublishers, MetricCollector apiCallMetricCollector, GetPermissionPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMobileSdkRelease$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMobileSdkRelease$98(List metricPublishers, MetricCollector apiCallMetricCollector, GetMobileSdkReleaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getManagedRuleSet$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getManagedRuleSet$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetManagedRuleSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoggingConfiguration$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoggingConfiguration$90(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getIPSet$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIPSet$86(List metricPublishers, MetricCollector apiCallMetricCollector, GetIpSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDecryptedAPIKey$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDecryptedAPIKey$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetDecryptedApiKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateMobileSdkReleaseUrl$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateMobileSdkReleaseUrl$78(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateMobileSdkReleaseUrlResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateWebACL$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateWebACL$74(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeManagedRuleGroup$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeManagedRuleGroup$70(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeManagedRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeManagedProductsByVendor$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeManagedProductsByVendor$66(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeManagedProductsByVendorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAllManagedProducts$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAllManagedProducts$62(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAllManagedProductsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWebACL$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebACL$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRuleGroup$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRuleGroup$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRegexPatternSet$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRegexPatternSet$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRegexPatternSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePermissionPolicy$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermissionPolicy$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePermissionPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoggingConfiguration$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoggingConfiguration$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoggingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteIPSet$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIPSet$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteIpSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFirewallManagerRuleGroups$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFirewallManagerRuleGroups$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFirewallManagerRuleGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAPIKey$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAPIKey$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApiKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createWebACL$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWebACL$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRuleGroup$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRuleGroup$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRuleGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRegexPatternSet$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRegexPatternSet$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRegexPatternSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createIPSet$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIPSet$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateIpSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAPIKey$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAPIKey$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateApiKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$checkCapacity$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkCapacity$6(List metricPublishers, MetricCollector apiCallMetricCollector, CheckCapacityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateWebACL$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateWebACL$2(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateWebAclResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

