/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Regex;
import software.amazon.awssdk.services.wafv2.model.RegularExpressionListCopier;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.Tag;
import software.amazon.awssdk.services.wafv2.model.TagListCopier;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRegexPatternSetRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, CreateRegexPatternSetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRegexPatternSetRequest.getter(CreateRegexPatternSetRequest::name)).setter(CreateRegexPatternSetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(CreateRegexPatternSetRequest.getter(CreateRegexPatternSetRequest::scopeAsString)).setter(CreateRegexPatternSetRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateRegexPatternSetRequest.getter(CreateRegexPatternSetRequest::description)).setter(CreateRegexPatternSetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Regex>> REGULAR_EXPRESSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegularExpressionList").getter(CreateRegexPatternSetRequest.getter(CreateRegexPatternSetRequest::regularExpressionList)).setter(CreateRegexPatternSetRequest.setter(Builder::regularExpressionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegularExpressionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Regex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRegexPatternSetRequest.getter(CreateRegexPatternSetRequest::tags)).setter(CreateRegexPatternSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD, DESCRIPTION_FIELD, REGULAR_EXPRESSION_LIST_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRegexPatternSetRequest.memberNameToFieldInitializer();
    private final String name;
    private final String scope;
    private final String description;
    private final List<Regex> regularExpressionList;
    private final List<Tag> tags;

    private CreateRegexPatternSetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.description = builder.description;
        this.regularExpressionList = builder.regularExpressionList;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRegularExpressionList() {
        return this.regularExpressionList != null && !(this.regularExpressionList instanceof SdkAutoConstructList);
    }

    public final List<Regex> regularExpressionList() {
        return this.regularExpressionList;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegularExpressionList() ? this.regularExpressionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegexPatternSetRequest)) {
            return false;
        }
        CreateRegexPatternSetRequest other = (CreateRegexPatternSetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.description(), other.description()) && this.hasRegularExpressionList() == other.hasRegularExpressionList() && Objects.equals(this.regularExpressionList(), other.regularExpressionList()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRegexPatternSetRequest").add("Name", (Object)this.name()).add("Scope", (Object)this.scopeAsString()).add("Description", (Object)this.description()).add("RegularExpressionList", this.hasRegularExpressionList() ? this.regularExpressionList() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RegularExpressionList": {
                return Optional.ofNullable(clazz.cast(this.regularExpressionList()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RegularExpressionList", REGULAR_EXPRESSION_LIST_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRegexPatternSetRequest, T> g) {
        return obj -> g.apply((CreateRegexPatternSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String name;
        private String scope;
        private String description;
        private List<Regex> regularExpressionList = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegexPatternSetRequest model) {
            super(model);
            this.name(model.name);
            this.scope(model.scope);
            this.description(model.description);
            this.regularExpressionList(model.regularExpressionList);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Regex.Builder> getRegularExpressionList() {
            List<Regex.Builder> result = RegularExpressionListCopier.copyToBuilder(this.regularExpressionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegularExpressionList(Collection<Regex.BuilderImpl> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copyFromBuilder(regularExpressionList);
        }

        @Override
        public final Builder regularExpressionList(Collection<Regex> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copy(regularExpressionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Regex ... regularExpressionList) {
            this.regularExpressionList(Arrays.asList(regularExpressionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Consumer<Regex.Builder> ... regularExpressionList) {
            this.regularExpressionList(Stream.of(regularExpressionList).map(c -> (Regex)((Regex.Builder)Regex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRegexPatternSetRequest build() {
            return new CreateRegexPatternSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRegexPatternSetRequest> {
        public Builder name(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder description(String var1);

        public Builder regularExpressionList(Collection<Regex> var1);

        public Builder regularExpressionList(Regex ... var1);

        public Builder regularExpressionList(Consumer<Regex.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

