/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.APIKeySummariesCopier;
import software.amazon.awssdk.services.wafv2.model.APIKeySummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApiKeysResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListApiKeysResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListApiKeysResponse.getter(ListApiKeysResponse::nextMarker)).setter(ListApiKeysResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<APIKeySummary>> API_KEY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("APIKeySummaries").getter(ListApiKeysResponse.getter(ListApiKeysResponse::apiKeySummaries)).setter(ListApiKeysResponse.setter(Builder::apiKeySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIKeySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(APIKeySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_INTEGRATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIntegrationURL").getter(ListApiKeysResponse.getter(ListApiKeysResponse::applicationIntegrationURL)).setter(ListApiKeysResponse.setter(Builder::applicationIntegrationURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIntegrationURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, API_KEY_SUMMARIES_FIELD, APPLICATION_INTEGRATION_URL_FIELD));
    private final String nextMarker;
    private final List<APIKeySummary> apiKeySummaries;
    private final String applicationIntegrationURL;

    private ListApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.apiKeySummaries = builder.apiKeySummaries;
        this.applicationIntegrationURL = builder.applicationIntegrationURL;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasApiKeySummaries() {
        return this.apiKeySummaries != null && !(this.apiKeySummaries instanceof SdkAutoConstructList);
    }

    public final List<APIKeySummary> apiKeySummaries() {
        return this.apiKeySummaries;
    }

    public final String applicationIntegrationURL() {
        return this.applicationIntegrationURL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApiKeySummaries() ? this.apiKeySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIntegrationURL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeysResponse)) {
            return false;
        }
        ListApiKeysResponse other = (ListApiKeysResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasApiKeySummaries() == other.hasApiKeySummaries() && Objects.equals(this.apiKeySummaries(), other.apiKeySummaries()) && Objects.equals(this.applicationIntegrationURL(), other.applicationIntegrationURL());
    }

    public final String toString() {
        return ToString.builder((String)"ListApiKeysResponse").add("NextMarker", (Object)this.nextMarker()).add("APIKeySummaries", this.hasApiKeySummaries() ? this.apiKeySummaries() : null).add("ApplicationIntegrationURL", (Object)this.applicationIntegrationURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "APIKeySummaries": {
                return Optional.ofNullable(clazz.cast(this.apiKeySummaries()));
            }
            case "ApplicationIntegrationURL": {
                return Optional.ofNullable(clazz.cast(this.applicationIntegrationURL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApiKeysResponse, T> g) {
        return obj -> g.apply((ListApiKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<APIKeySummary> apiKeySummaries = DefaultSdkAutoConstructList.getInstance();
        private String applicationIntegrationURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeysResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.apiKeySummaries(model.apiKeySummaries);
            this.applicationIntegrationURL(model.applicationIntegrationURL);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<APIKeySummary.Builder> getApiKeySummaries() {
            List<APIKeySummary.Builder> result = APIKeySummariesCopier.copyToBuilder(this.apiKeySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiKeySummaries(Collection<APIKeySummary.BuilderImpl> apiKeySummaries) {
            this.apiKeySummaries = APIKeySummariesCopier.copyFromBuilder(apiKeySummaries);
        }

        @Override
        public final Builder apiKeySummaries(Collection<APIKeySummary> apiKeySummaries) {
            this.apiKeySummaries = APIKeySummariesCopier.copy(apiKeySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeySummaries(APIKeySummary ... apiKeySummaries) {
            this.apiKeySummaries(Arrays.asList(apiKeySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeySummaries(Consumer<APIKeySummary.Builder> ... apiKeySummaries) {
            this.apiKeySummaries(Stream.of(apiKeySummaries).map(c -> (APIKeySummary)((APIKeySummary.Builder)APIKeySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationIntegrationURL() {
            return this.applicationIntegrationURL;
        }

        public final void setApplicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
        }

        @Override
        public final Builder applicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
            return this;
        }

        @Override
        public ListApiKeysResponse build() {
            return new ListApiKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApiKeysResponse> {
        public Builder nextMarker(String var1);

        public Builder apiKeySummaries(Collection<APIKeySummary> var1);

        public Builder apiKeySummaries(APIKeySummary ... var1);

        public Builder apiKeySummaries(Consumer<APIKeySummary.Builder> ... var1);

        public Builder applicationIntegrationURL(String var1);
    }
}

